/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.transformer;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Transformer;

@Metadata(label="transformation")
@XmlType(name="customTransformer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomTransformerDefinition
extends TransformerDefinition {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String className;

    @Override
    protected Transformer doCreateTransformer(CamelContext context) throws Exception {
        Transformer transformer;
        if (this.ref == null && this.className == null) {
            throw new IllegalArgumentException("'ref' or 'className' must be specified for customTransformer");
        }
        if (this.ref != null) {
            transformer = context.getRegistry().lookupByNameAndType(this.ref, Transformer.class);
            if (transformer == null) {
                throw new IllegalArgumentException("Cannot find transformer with ref:" + this.ref);
            }
            if (transformer.getModel() != null || transformer.getFrom() != null || transformer.getTo() != null) {
                throw new IllegalArgumentException(String.format("Transformer '%s' is already in use. Please check if duplicate transformer exists.", this.ref));
            }
        } else {
            Class<Transformer> transformerClass = context.getClassResolver().resolveMandatoryClass(this.className, Transformer.class);
            if (transformerClass == null) {
                throw new IllegalArgumentException("Cannot find transformer class: " + this.className);
            }
            transformer = context.getInjector().newInstance(transformerClass);
        }
        transformer.setCamelContext(context);
        return transformer.setModel(this.getScheme()).setFrom(this.getFromType()).setTo(this.getToType());
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

