/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashSet;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimCheckAggregationStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimCheckAggregationStrategy.class);
    private String filter;

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String part;
        if (newExchange == null) {
            return oldExchange;
        }
        if (ObjectHelper.isEmpty(this.filter) || "*".equals(this.filter)) {
            oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
            LOG.trace("Including: body");
            if (newExchange.getMessage().hasHeaders()) {
                oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
                LOG.trace("Including: headers");
            }
            if (newExchange.getMessage().hasAttachments()) {
                oldExchange.getMessage().getAttachments().putAll(newExchange.getMessage().getAttachments());
                LOG.trace("Including: attachments");
            }
            return oldExchange;
        }
        if (this.isBodyEnabled()) {
            oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
            LOG.trace("Including: body");
        }
        if (this.isAttachmentsEnabled() && newExchange.getMessage().hasAttachments()) {
            oldExchange.getMessage().getAttachments().putAll(newExchange.getMessage().getAttachments());
            LOG.trace("Including: attachments");
        }
        if (this.isHeadersEnabled() && newExchange.getMessage().hasHeaders()) {
            oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
            LOG.trace("Including: headers");
        }
        if (this.hasHeaderPatterns()) {
            boolean excludeOnly = this.isExcludeOnlyHeaderPatterns();
            for (Map.Entry entry : newExchange.getMessage().getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                if (this.hasHeaderPattern(key)) {
                    boolean include = this.isIncludedHeader(key);
                    boolean exclude = this.isExcludedHeader(key);
                    if (include) {
                        LOG.trace("Including: header:{}", (Object)key);
                        oldExchange.getMessage().getHeaders().put(key, entry.getValue());
                        continue;
                    }
                    if (exclude) {
                        LOG.trace("Excluding: header:{}", (Object)key);
                        continue;
                    }
                    LOG.trace("Skipping: header:{}", (Object)key);
                    continue;
                }
                if (!excludeOnly) continue;
                LOG.trace("Including: header:{}", (Object)key);
                oldExchange.getMessage().getHeaders().put(key, entry.getValue());
            }
        }
        if (ObjectHelper.isNotEmpty(this.filter)) {
            Iterable<Object> it = ObjectHelper.createIterable(this.filter, ",");
            for (Object object : it) {
                part = object.toString();
                if (("body".equals(part) || "+body".equals(part)) && !"-body".equals(part)) {
                    oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
                    LOG.trace("Including: body");
                    continue;
                }
                if (!"headers".equals(part) && !"+headers".equals(part) || "-headers".equals(part)) continue;
                oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
                LOG.trace("Including: headers");
            }
        }
        Iterable<Object> it = ObjectHelper.createIterable(this.filter, ",");
        for (Object object : it) {
            part = object.toString();
            if ("--body".equals(part)) {
                oldExchange.getMessage().setBody(null);
                continue;
            }
            if ("--headers".equals(part)) {
                oldExchange.getMessage().getHeaders().clear();
                continue;
            }
            if (!part.startsWith("--header:")) continue;
            String after = StringHelper.after(part, "--header:");
            Iterable<Object> i = ObjectHelper.createIterable(after, ",");
            HashSet<String> toRemoveKeys = new HashSet<String>();
            for (Object o : i) {
                String pattern = o.toString();
                for (Map.Entry<String, Object> header : oldExchange.getMessage().getHeaders().entrySet()) {
                    String key = header.getKey();
                    boolean matched = EndpointHelper.matchPattern(key, pattern);
                    if (!matched) continue;
                    toRemoveKeys.add(key);
                }
            }
            for (String key : toRemoveKeys) {
                LOG.trace("Removing: header:{}", (Object)key);
                oldExchange.getMessage().removeHeader(key);
            }
        }
        return oldExchange;
    }

    private boolean hasHeaderPatterns() {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--") || !pattern.startsWith("header:") && !pattern.startsWith("+header:") && !pattern.startsWith("-header:")) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeOnlyHeaderPatterns() {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--") || !pattern.startsWith("header:") && !pattern.startsWith("+header:")) continue;
            return false;
        }
        return true;
    }

    private boolean hasHeaderPattern(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            String header = null;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                header = StringHelper.after(pattern, "header:");
            } else if (pattern.startsWith("-header:")) {
                header = StringHelper.after(pattern, "-header:");
            }
            if (header == null || !EndpointHelper.matchPattern(key, header)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludedHeader(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                pattern = StringHelper.after(pattern, "header:");
            }
            if (!EndpointHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedHeader(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("-header:")) {
                pattern = StringHelper.after(pattern, "-header:");
            }
            if (!EndpointHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isBodyEnabled() {
        String[] parts = this.filter.split(",");
        boolean onlyExclude = true;
        for (String pattern : parts) {
            if (pattern.startsWith("--")) continue;
            if ("body".equals(pattern) || "+body".equals(pattern)) {
                return true;
            }
            if ("-body".equals(pattern)) {
                return false;
            }
            onlyExclude &= pattern.startsWith("-");
        }
        return onlyExclude;
    }

    private boolean isAttachmentsEnabled() {
        String[] parts = this.filter.split(",");
        boolean onlyExclude = true;
        for (String pattern : parts) {
            if (pattern.startsWith("--")) continue;
            if ("attachments".equals(pattern) || "+attachments".equals(pattern)) {
                return true;
            }
            if ("-attachments".equals(pattern)) {
                return false;
            }
            onlyExclude &= pattern.startsWith("-");
        }
        return onlyExclude;
    }

    private boolean isHeadersEnabled() {
        String[] parts = this.filter.split(",");
        boolean onlyExclude = true;
        for (String pattern : parts) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:") || pattern.startsWith("-header:")) {
                return false;
            }
            if ("headers".equals(pattern) || "+headers".equals(pattern)) {
                return true;
            }
            if ("-headers".equals(pattern)) {
                return false;
            }
            onlyExclude &= pattern.startsWith("-");
        }
        return onlyExclude;
    }
}

