/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.camel.util.StringHelper;

public final class InetAddressUtil {
    private InetAddressUtil() {
    }

    public static String getLocalHostName() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            String host = uhe.getMessage();
            if (host != null) {
                return StringHelper.before(host, ":");
            }
            throw uhe;
        }
    }

    public static String getLocalHostNameSafe() {
        try {
            return InetAddressUtil.getLocalHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

