/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="1.0.0", label="dataformat,transformation,xml", title="JAXB")
@XmlRootElement(name="jaxb")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlAttribute(required=true)
    private String contextPath;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String contextPathIsClassName;
    @XmlAttribute
    private String schema;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", enums="0,1,2", defaultValue="0")
    private String schemaSeverityLevel;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String prettyPrint;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String objectFactory;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String ignoreJAXBElement;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String mustBeJAXBElement;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String filterNonXmlChars;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String fragment;
    @XmlAttribute
    @Metadata(label="advanced")
    private String partClass;
    @XmlAttribute
    @Metadata(label="advanced")
    private String partNamespace;
    @XmlAttribute
    @Metadata(label="advanced")
    private String namespacePrefixRef;
    @XmlAttribute
    @Metadata(label="advanced")
    private String xmlStreamWriterWrapper;
    @XmlAttribute
    private String schemaLocation;
    @XmlAttribute
    @Metadata(label="advanced")
    private String noNamespaceSchemaLocation;
    @XmlAttribute
    @Metadata(label="advanced")
    private String jaxbProviderProperties;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;
    @XmlAttribute
    @Metadata(label="security", defaultValue="false")
    private String accessExternalSchemaProtocols;

    public JaxbDataFormat() {
        super("jaxb");
    }

    private JaxbDataFormat(JaxbDataFormat source) {
        super(source);
        this.contextPath = source.contextPath;
        this.contextPathIsClassName = source.contextPathIsClassName;
        this.schema = source.schema;
        this.schemaSeverityLevel = source.schemaSeverityLevel;
        this.prettyPrint = source.prettyPrint;
        this.objectFactory = source.objectFactory;
        this.ignoreJAXBElement = source.ignoreJAXBElement;
        this.mustBeJAXBElement = source.mustBeJAXBElement;
        this.filterNonXmlChars = source.filterNonXmlChars;
        this.encoding = source.encoding;
        this.fragment = source.fragment;
        this.partClass = source.partClass;
        this.partNamespace = source.partNamespace;
        this.namespacePrefixRef = source.namespacePrefixRef;
        this.xmlStreamWriterWrapper = source.xmlStreamWriterWrapper;
        this.schemaLocation = source.schemaLocation;
        this.noNamespaceSchemaLocation = source.noNamespaceSchemaLocation;
        this.jaxbProviderProperties = source.jaxbProviderProperties;
        this.contentTypeHeader = source.contentTypeHeader;
        this.accessExternalSchemaProtocols = source.accessExternalSchemaProtocols;
    }

    public JaxbDataFormat(boolean prettyPrint) {
        this();
        this.setPrettyPrint(Boolean.toString(prettyPrint));
    }

    private JaxbDataFormat(Builder builder) {
        this();
        this.contextPath = builder.contextPath;
        this.contextPathIsClassName = builder.contextPathIsClassName;
        this.schema = builder.schema;
        this.schemaSeverityLevel = builder.schemaSeverityLevel;
        this.prettyPrint = builder.prettyPrint;
        this.objectFactory = builder.objectFactory;
        this.ignoreJAXBElement = builder.ignoreJAXBElement;
        this.mustBeJAXBElement = builder.mustBeJAXBElement;
        this.filterNonXmlChars = builder.filterNonXmlChars;
        this.encoding = builder.encoding;
        this.fragment = builder.fragment;
        this.partClass = builder.partClass;
        this.partNamespace = builder.partNamespace;
        this.namespacePrefixRef = builder.namespacePrefixRef;
        this.xmlStreamWriterWrapper = builder.xmlStreamWriterWrapper;
        this.schemaLocation = builder.schemaLocation;
        this.noNamespaceSchemaLocation = builder.noNamespaceSchemaLocation;
        this.jaxbProviderProperties = builder.jaxbProviderProperties;
        this.contentTypeHeader = builder.contentTypeHeader;
        this.accessExternalSchemaProtocols = builder.accessExternalSchemaProtocols;
    }

    @Override
    public JaxbDataFormat copyDefinition() {
        return new JaxbDataFormat(this);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPathIsClassName() {
        return this.contextPathIsClassName;
    }

    public void setContextPathIsClassName(String contextPathIsClassName) {
        this.contextPathIsClassName = contextPathIsClassName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchemaSeverityLevel() {
        return this.schemaSeverityLevel;
    }

    public void setSchemaSeverityLevel(String schemaSeverityLevel) {
        this.schemaSeverityLevel = schemaSeverityLevel;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(String ignoreJAXBElement) {
        this.ignoreJAXBElement = ignoreJAXBElement;
    }

    public String getMustBeJAXBElement() {
        return this.mustBeJAXBElement;
    }

    public void setMustBeJAXBElement(String mustBeJAXBElement) {
        this.mustBeJAXBElement = mustBeJAXBElement;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(String filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPartClass() {
        return this.partClass;
    }

    public void setPartClass(String partClass) {
        this.partClass = partClass;
    }

    public String getPartNamespace() {
        return this.partNamespace;
    }

    public void setPartNamespace(String partNamespace) {
        this.partNamespace = partNamespace;
    }

    public String getNamespacePrefixRef() {
        return this.namespacePrefixRef;
    }

    public void setNamespacePrefixRef(String namespacePrefixRef) {
        this.namespacePrefixRef = namespacePrefixRef;
    }

    public String getXmlStreamWriterWrapper() {
        return this.xmlStreamWriterWrapper;
    }

    public void setXmlStreamWriterWrapper(String xmlStreamWriterWrapperRef) {
        this.xmlStreamWriterWrapper = xmlStreamWriterWrapperRef;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        this.noNamespaceSchemaLocation = schemaLocation;
    }

    public String getJaxbProviderProperties() {
        return this.jaxbProviderProperties;
    }

    public void setJaxbProviderProperties(String jaxbProviderProperties) {
        this.jaxbProviderProperties = jaxbProviderProperties;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getAccessExternalSchemaProtocols() {
        return this.accessExternalSchemaProtocols;
    }

    public void setAccessExternalSchemaProtocols(String accessExternalSchemaProtocols) {
        this.accessExternalSchemaProtocols = accessExternalSchemaProtocols;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<JaxbDataFormat> {
        private String contextPath;
        private String contextPathIsClassName;
        private String schema;
        private String schemaSeverityLevel;
        private String prettyPrint;
        private String objectFactory;
        private String ignoreJAXBElement;
        private String mustBeJAXBElement;
        private String filterNonXmlChars;
        private String encoding;
        private String fragment;
        private String partClass;
        private String partNamespace;
        private String namespacePrefixRef;
        private String xmlStreamWriterWrapper;
        private String schemaLocation;
        private String noNamespaceSchemaLocation;
        private String jaxbProviderProperties;
        private String contentTypeHeader;
        private String accessExternalSchemaProtocols;

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder contextPathIsClassName(String contextPathIsClassName) {
            this.contextPathIsClassName = contextPathIsClassName;
            return this;
        }

        public Builder contextPathIsClassName(boolean contextPathIsClassName) {
            this.contextPathIsClassName = Boolean.toString(contextPathIsClassName);
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder schemaSeverityLevel(String schemaSeverityLevel) {
            this.schemaSeverityLevel = schemaSeverityLevel;
            return this;
        }

        public Builder schemaSeverityLevel(int schemaSeverityLevel) {
            this.schemaSeverityLevel = Integer.toString(schemaSeverityLevel);
            return this;
        }

        public Builder prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return this;
        }

        public Builder objectFactory(String objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public Builder objectFactory(boolean objectFactory) {
            this.objectFactory = Boolean.toString(objectFactory);
            return this;
        }

        public Builder ignoreJAXBElement(String ignoreJAXBElement) {
            this.ignoreJAXBElement = ignoreJAXBElement;
            return this;
        }

        public Builder ignoreJAXBElement(boolean ignoreJAXBElement) {
            this.ignoreJAXBElement = Boolean.toString(ignoreJAXBElement);
            return this;
        }

        public Builder mustBeJAXBElement(String mustBeJAXBElement) {
            this.mustBeJAXBElement = mustBeJAXBElement;
            return this;
        }

        public Builder mustBeJAXBElement(boolean mustBeJAXBElement) {
            this.mustBeJAXBElement = Boolean.toString(mustBeJAXBElement);
            return this;
        }

        public Builder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder fragment(boolean fragment) {
            this.fragment = Boolean.toString(fragment);
            return this;
        }

        public Builder filterNonXmlChars(String filterNonXmlChars) {
            this.filterNonXmlChars = filterNonXmlChars;
            return this;
        }

        public Builder filterNonXmlChars(boolean filterNonXmlChars) {
            this.filterNonXmlChars = Boolean.toString(filterNonXmlChars);
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder partClass(String partClass) {
            this.partClass = partClass;
            return this;
        }

        public Builder partNamespace(String partNamespace) {
            this.partNamespace = partNamespace;
            return this;
        }

        public Builder namespacePrefixRef(String namespacePrefixRef) {
            this.namespacePrefixRef = namespacePrefixRef;
            return this;
        }

        public Builder xmlStreamWriterWrapper(String xmlStreamWriterWrapperRef) {
            this.xmlStreamWriterWrapper = xmlStreamWriterWrapperRef;
            return this;
        }

        public Builder schemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public Builder noNamespaceSchemaLocation(String schemaLocation) {
            this.noNamespaceSchemaLocation = schemaLocation;
            return this;
        }

        public Builder jaxbProviderProperties(String jaxbProviderProperties) {
            this.jaxbProviderProperties = jaxbProviderProperties;
            return this;
        }

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        public Builder accessExternalSchemaProtocols(String accessExternalSchemaProtocols) {
            this.accessExternalSchemaProtocols = accessExternalSchemaProtocols;
            return this;
        }

        @Override
        public JaxbDataFormat end() {
            return new JaxbDataFormat(this);
        }
    }
}

