/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import javax.annotation.security.RolesAllowed;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

public class RolesAllowedAnnotationHandler
extends AuthorizingAnnotationHandler {
    public RolesAllowedAnnotationHandler() {
        super(RolesAllowed.class);
    }

    @Override
    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RolesAllowed)) {
            return;
        }
        RolesAllowed raAnnotation = (RolesAllowed)a;
        String[] roles = raAnnotation.value();
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
            return;
        }
        boolean hasAtLeastOneRole = false;
        for (String role : roles) {
            if (!this.getSubject().hasRole(role)) continue;
            hasAtLeastOneRole = true;
        }
        if (!hasAtLeastOneRole) {
            this.getSubject().checkRole(roles[0]);
        }
    }
}

