/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;

public class JolokiaFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (AuditLogger.isAnyLoggingEnabled() && servletRequest != null) {
            String remoteHost = servletRequest.getRemoteHost();
            AuditLogger.setRemoteAddress((String)(remoteHost + ":" + servletRequest.getRemotePort()));
        }
        filterChain.doFilter(servletRequest, servletResponse);
        if (AuditLogger.isAnyLoggingEnabled()) {
            try {
                Session session = ((Request)servletRequest).getSession(true);
                Subject subject = (Subject)session.getAttribute("subject");
                AuditLogger.setCurrentCaller((Subject)subject);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }
}

