/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.SimpleString;

public class MirrorAddressFilter {
    private final SimpleString[] allowList;
    private final SimpleString[] denyList;

    public MirrorAddressFilter(String filter) {
        HashSet<SimpleString> allowList = new HashSet<SimpleString>();
        HashSet<SimpleString> denyList = new HashSet<SimpleString>();
        if (filter != null && !filter.isEmpty()) {
            String[] parts;
            for (String part : parts = filter.split(",")) {
                if ("".equals(part) || "!".equals(part)) continue;
                if (part.startsWith("!")) {
                    denyList.add(SimpleString.of((String)part.substring(1)));
                    continue;
                }
                allowList.add(SimpleString.of((String)part));
            }
        }
        this.allowList = allowList.toArray(new SimpleString[0]);
        this.denyList = denyList.toArray(new SimpleString[0]);
    }

    public boolean match(SimpleString checkAddress) {
        if (this.denyList.length > 0) {
            for (SimpleString pattern : this.denyList) {
                if (!checkAddress.startsWith(pattern)) continue;
                return false;
            }
        }
        if (this.allowList.length > 0) {
            for (SimpleString pattern : this.allowList) {
                if (!checkAddress.startsWith(pattern)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

