/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.Axis;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.NodeIterator;
import org.apache.axiom.dom.DOMAttribute;
import org.apache.axiom.dom.DOMCDATASection;
import org.apache.axiom.dom.DOMComment;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMDocumentFragment;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMEntityReference;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNSAwareAttribute;
import org.apache.axiom.dom.DOMNSAwareElement;
import org.apache.axiom.dom.DOMNSAwareNamedNode;
import org.apache.axiom.dom.DOMNSUnawareAttribute;
import org.apache.axiom.dom.DOMNSUnawareElement;
import org.apache.axiom.dom.DOMNamespaceDeclaration;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMProcessingInstruction;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DOMText;
import org.apache.axiom.dom.ElementsByTagName;
import org.apache.axiom.dom.ElementsByTagNameNS;
import org.apache.axiom.dom.NSUtil;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

@Mixin
public abstract class DOMDocumentMixin
implements DOMDocument {
    private final DOMConfigurationImpl domConfig = new DOMConfigurationImpl();
    private String documentURI;
    private boolean strictErrorChecking = true;

    @Override
    public final Document getOwnerDocument() {
        return null;
    }

    @Override
    public final String getNodeName() {
        return "#document";
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    @Override
    public final String getNodeValue() {
        return null;
    }

    @Override
    public final void setNodeValue(String nodeValue) {
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    @Override
    public final String getNamespaceURI() {
        return null;
    }

    @Override
    public final String getLocalName() {
        return null;
    }

    @Override
    public final boolean hasAttributes() {
        return false;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return null;
    }

    @Override
    public final void setTextContent(String textContent) {
    }

    @Override
    public final Element getDocumentElement() {
        try {
            return (Element)((Object)this.coreGetDocumentElement());
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final CoreElement getNamespaceContext() {
        try {
            return this.coreGetDocumentElement();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final DOMImplementation getImplementation() {
        return this.getDOMNodeFactory();
    }

    @Override
    public final DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public final String getInputEncoding() {
        return this.coreGetInputEncoding();
    }

    @Override
    public final String getXmlVersion() {
        String version = this.coreGetXmlVersion();
        return version == null ? "1.0" : version;
    }

    @Override
    public final void setXmlVersion(String version) {
        this.coreSetXmlVersion(version);
    }

    @Override
    public final String getXmlEncoding() {
        return this.coreGetXmlEncoding();
    }

    @Override
    public final boolean getXmlStandalone() {
        Boolean standalone = this.coreGetStandalone();
        return standalone != null && standalone != false;
    }

    @Override
    public final void setXmlStandalone(boolean standalone) {
        this.coreSetStandalone(standalone);
    }

    @Override
    public final void normalizeDocument() {
        if (this.domConfig.isEnabled(1024) || this.domConfig.isEnabled(8192)) {
            throw new UnsupportedOperationException("TODO");
        }
        this.normalizeRecursively(this.domConfig);
    }

    @Override
    public final Text createTextNode(String data) {
        DOMText text = this.getDOMNodeFactory().createCharacterDataNode();
        text.coreSetOwnerDocument(this);
        text.coreSetCharacterData(data);
        return text;
    }

    @Override
    public final CDATASection createCDATASection(String data) {
        try {
            DOMCDATASection cdataSection = this.getDOMNodeFactory().createCDATASection();
            cdataSection.coreSetOwnerDocument(this);
            cdataSection.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return cdataSection;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Element createElement(String tagName) {
        NSUtil.validateName(tagName);
        DOMNSUnawareElement element = this.getDOMNodeFactory().createNSUnawareElement();
        element.coreSetOwnerDocument(this);
        element.coreSetName(tagName);
        return element;
    }

    @Override
    public final Attr createAttribute(String name) {
        NSUtil.validateName(name);
        DOMNSUnawareAttribute attr = this.getDOMNodeFactory().createNSUnawareAttribute();
        attr.coreSetOwnerDocument(this);
        attr.coreSetName(name);
        attr.coreSetType("CDATA");
        return attr;
    }

    @Override
    public final Element createElementNS(String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        NSUtil.validateNamespace(namespaceURI, prefix);
        DOMNSAwareElement element = this.getDOMNodeFactory().createNSAwareElement();
        element.coreSetOwnerDocument(this);
        element.coreSetName(namespaceURI, localName, prefix);
        return element;
    }

    @Override
    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            DOMNamespaceDeclaration decl = this.getDOMNodeFactory().createNamespaceDeclaration();
            decl.coreSetOwnerDocument(this);
            decl.coreSetDeclaredNamespace(NSUtil.getDeclaredPrefix(localName, prefix), "");
            return decl;
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        NSUtil.validateAttributeName(namespaceURI, localName, prefix);
        DOMNSAwareAttribute attr = this.getDOMNodeFactory().createNSAwareAttribute();
        attr.coreSetOwnerDocument(this);
        attr.coreSetName(namespaceURI, localName, prefix);
        return attr;
    }

    @Override
    public final ProcessingInstruction createProcessingInstruction(String target, String data) {
        try {
            DOMProcessingInstruction pi = this.getDOMNodeFactory().createProcessingInstruction();
            pi.coreSetOwnerDocument(this);
            pi.coreSetTarget(target);
            pi.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return pi;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final EntityReference createEntityReference(String name) throws DOMException {
        DOMEntityReference node = this.getDOMNodeFactory().createEntityReference();
        node.coreSetOwnerDocument(this);
        node.coreSetName(name);
        return node;
    }

    @Override
    public final Comment createComment(String data) {
        try {
            DOMComment node = this.getDOMNodeFactory().createComment();
            node.coreSetOwnerDocument(this);
            node.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return node;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        DOMDocumentFragment fragment = this.getDOMNodeFactory().createDocumentFragment();
        fragment.coreSetOwnerDocument(this);
        return fragment;
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        return new ElementsByTagName(this, tagname);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new ElementsByTagNameNS(this, namespaceURI, localName);
    }

    @Override
    public final Node renameNode(Node node, String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        if (!(node instanceof DOMNode) || !((DOMNode)node).coreHasSameOwnerDocument(this)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        if (!(node instanceof DOMNSAwareNamedNode)) {
            throw DOMExceptionUtil.newDOMException((short)9);
        }
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        switch (((DOMNode)node).coreGetNodeType()) {
            case NS_AWARE_ELEMENT: {
                NSUtil.validateNamespace(namespaceURI, prefix);
                ((DOMNSAwareElement)node).coreSetName(namespaceURI, localName, prefix);
                return node;
            }
            case NS_AWARE_ATTRIBUTE: {
                if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    DOMNamespaceDeclaration decl = this.getDOMNodeFactory().createNamespaceDeclaration();
                    decl.coreSetOwnerDocument(this);
                    decl.coreSetDeclaredNamespace(NSUtil.getDeclaredPrefix(localName, prefix), ((DOMNSAwareAttribute)node).getValue());
                    return decl;
                }
                NSUtil.validateAttributeName(namespaceURI, localName, prefix);
                ((DOMNSAwareAttribute)node).coreSetName(namespaceURI, localName, prefix);
                return node;
            }
            case NAMESPACE_DECLARATION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final DocumentType getDoctype() {
        try {
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                if (child instanceof DocumentType) {
                    return (DocumentType)((Object)child);
                }
                if (!(child instanceof Element)) continue;
                return null;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node adoptNode(Node node) throws DOMException {
        if (node instanceof DOMNode) {
            DOMNode childNode = (DOMNode)node;
            if (childNode instanceof CoreChildNode) {
                ((CoreChildNode)((Object)childNode)).coreDetach(this);
            } else {
                childNode.coreSetOwnerDocument(this);
            }
            if (node instanceof DOMAttribute) {
                ((DOMAttribute)node).coreSetSpecified(true);
            }
            return childNode;
        }
        return null;
    }

    final void checkNewChild0(DOMNode newChild) {
        if (newChild instanceof DOMText) {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
    }

    @Override
    public final Element getElementById(String elementId) {
        try {
            NodeIterator it = this.coreGetNodes(Axis.DESCENDANTS, DOMElement.class, Mappers.identity(), DOMSemantics.INSTANCE);
            while (it.hasNext()) {
                DOMElement element = (DOMElement)it.next();
                for (CoreAttribute attr = element.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                    if (!((DOMAttribute)attr).isId() || !elementId.equals(attr.coreGetCharacterData().toString())) continue;
                    return element;
                }
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public final void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public final boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public final void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public final void normalize(DOMConfigurationImpl config) {
    }

    @Override
    public final Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        ((DOMElement)newElement).coreAppendAttribute((DOMAttribute)this.importNode(sourceAttrs.item(index), true));
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if (importedNode.getLocalName() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: {
                newNode = this.createCDATASection(importedNode.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)importedNode;
                newNode = this.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                throw DOMExceptionUtil.newDOMException((short)9);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            for (Node srckid = importedNode.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newNode.appendChild(this.importNode(srckid, true));
            }
        }
        return newNode;
    }
}

