/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.stax.pull;

import javax.xml.stream.XMLStreamException;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.stream.stax.pull.output.InternalXMLStreamReader;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.ext.stax.BlobReader;
import org.apache.axiom.om.impl.intf.TextContent;

final class BlobReaderImpl
implements BlobReader {
    private final InternalXMLStreamReader reader;

    BlobReaderImpl(InternalXMLStreamReader reader) {
        this.reader = reader;
    }

    public boolean isBinary() {
        if (this.reader.getEventType() == 4) {
            Object data = this.reader.getCharacterData();
            return data instanceof TextContent && ((TextContent)data).isBinary();
        }
        return false;
    }

    public boolean isOptimized() {
        return ((TextContent)this.reader.getCharacterData()).isOptimize();
    }

    public boolean isDeferred() {
        return ((TextContent)this.reader.getCharacterData()).getBlobObject() instanceof BlobProvider;
    }

    public String getContentID() {
        return ((TextContent)this.reader.getCharacterData()).getContentID();
    }

    public Blob getBlob() throws XMLStreamException {
        return ((TextContent)this.reader.getCharacterData()).getBlob();
    }

    public BlobProvider getBlobProvider() {
        return (BlobProvider)((TextContent)this.reader.getCharacterData()).getBlobObject();
    }
}

