/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.util;

import java.lang.reflect.Array;

public class ObjectStack {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_countPresent;
    protected int m_maximumGrowth;
    protected Object[] m_baseArray;

    public ObjectStack(int size, int growth) {
        this.m_countLimit = size;
        this.m_maximumGrowth = growth;
        this.m_baseArray = new Object[size];
    }

    public ObjectStack(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public ObjectStack() {
        this(8);
    }

    public ObjectStack(ObjectStack base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    public ObjectStack(Object[] strings) {
        this(strings.length);
        System.arraycopy(strings, 0, this.m_baseArray, 0, strings.length);
        this.m_countPresent = strings.length;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void discardValues(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.m_baseArray[i] = null;
        }
    }

    private void growArray(int required) {
        int size = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        Object[] grown = new Object[size];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min) {
        if (min > this.m_countLimit) {
            this.growArray(min);
        }
    }

    public void push(Object value) {
        int index = this.getAddIndex();
        this.m_baseArray[index] = value;
    }

    public Object pop() {
        if (this.m_countPresent > 0) {
            Object value = this.m_baseArray[--this.m_countPresent];
            this.m_baseArray[this.m_countPresent] = null;
            return value;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public Object pop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= count) {
            this.m_countPresent -= count;
            Object value = this.m_baseArray[this.m_countPresent];
            this.discardValues(this.m_countPresent, this.m_countPresent + count);
            return value;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public Object peek(int depth) {
        if (this.m_countPresent > depth) {
            return this.m_baseArray[this.m_countPresent - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public Object peek() {
        return this.peek(0);
    }

    public Object[] toArray() {
        Object[] copy = new Object[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new ObjectStack(this);
    }

    private int getAddIndex() {
        int index = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.discardValues(0, this.m_countPresent);
        this.m_countPresent = 0;
    }
}

