/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler.lifecycle.impl;

import jakarta.xml.ws.handler.Handler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.lifecycle.BaseLifecycleManager;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescriptionFactory;

public class HandlerLifecycleManagerImpl
extends BaseLifecycleManager
implements HandlerLifecycleManager {
    @Override
    public Handler createHandlerInstance(MessageContext mc, Class handlerClass) throws LifecycleException, ResourceInjectionException {
        if (handlerClass == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createHandlerInstanceErr"));
        }
        ServiceDescription serviceDesc = mc.getEndpointDescription().getServiceDescription();
        ResourceInjectionServiceRuntimeDescription injectionDesc = null;
        if (serviceDesc != null) {
            injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, handlerClass);
        }
        try {
            this.instance = handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        if (injectionDesc != null && injectionDesc.getPostConstructMethod() != null) {
            this.invokePostConstruct(injectionDesc.getPostConstructMethod());
        }
        return (Handler)this.instance;
    }

    @Override
    public void destroyHandlerInstance(MessageContext mc, Handler handler) throws LifecycleException, ResourceInjectionException {
        if (handler == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"destroyHandlerInstanceErr"));
        }
        this.instance = handler;
        ServiceDescription serviceDesc = mc.getEndpointDescription().getServiceDescription();
        ResourceInjectionServiceRuntimeDescription injectionDesc = null;
        if (serviceDesc != null) {
            injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, handler.getClass());
        }
        if (injectionDesc != null && injectionDesc.getPreDestroyMethod() != null) {
            this.invokePreDestroy(injectionDesc.getPreDestroyMethod());
        }
    }
}

