/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.json.factory.JSONType;
import org.apache.axis2.json.factory.JsonObject;
import org.apache.axis2.json.factory.XmlNode;
import org.apache.axis2.json.factory.XmlNodeGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;

public class GsonXMLStreamReader
implements XMLStreamReader {
    private static final Log log = LogFactory.getLog(GsonXMLStreamReader.class);
    private JsonReader jsonReader;
    private JsonState state = JsonState.StartState;
    private JsonToken tokenType;
    private String localName;
    private String value;
    private boolean isProcessed;
    private ConfigurationContext configContext;
    private QName elementQname;
    private XmlNode mainXmlNode;
    private List<XmlSchema> xmlSchemaList;
    private Queue<JsonObject> queue = new LinkedList<JsonObject>();
    private XmlNodeGenerator xmlNodeGenerator;
    private Stack<JsonObject> stackObj = new Stack();
    private Stack<JsonObject> miniStack = new Stack();
    private JsonObject topNestedArrayObj = null;
    private Stack<JsonObject> processedJsonObject = new Stack();
    private String namespace;

    public GsonXMLStreamReader(JsonReader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public GsonXMLStreamReader(JsonReader jsonReader, QName elementQname, List<XmlSchema> xmlSchemaList, ConfigurationContext configContext) throws AxisFault {
        this.jsonReader = jsonReader;
        this.initXmlStreamReader(elementQname, xmlSchemaList, configContext);
    }

    public JsonReader getJsonReader() {
        return this.jsonReader;
    }

    public void initXmlStreamReader(QName elementQname, List<XmlSchema> xmlSchemaList, ConfigurationContext configContext) throws AxisFault {
        this.elementQname = elementQname;
        this.xmlSchemaList = xmlSchemaList;
        this.configContext = configContext;
        try {
            this.process();
        }
        catch (AxisFault axisFault) {
            throw new AxisFault("Error while initializing XMLStreamReader ", (Throwable)axisFault);
        }
        this.isProcessed = true;
    }

    private void process() throws AxisFault {
        Object ob = this.configContext.getProperty("xmlnodes");
        if (ob != null) {
            Map nodeMap = (Map)ob;
            XmlNode requesNode = (XmlNode)nodeMap.get(this.elementQname);
            if (requesNode != null) {
                this.xmlNodeGenerator = new XmlNodeGenerator();
                this.queue = this.xmlNodeGenerator.getQueue(requesNode);
            } else {
                this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQname);
                this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
                this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
                nodeMap.put(this.elementQname, this.mainXmlNode);
                this.configContext.setProperty("xmlnodes", (Object)nodeMap);
            }
        } else {
            HashMap<QName, XmlNode> newNodeMap = new HashMap<QName, XmlNode>();
            this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQname);
            this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
            this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
            newNodeMap.put(this.elementQname, this.mainXmlNode);
            this.configContext.setProperty("xmlnodes", newNodeMap);
        }
        log.debug((Object)"GsonXMLStreamReader.process() completed");
        this.isProcessed = true;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.hasNext()) {
            try {
                this.stateTransition();
            }
            catch (IOException e) {
                throw new XMLStreamException("I/O error while reading JSON input Stream");
            }
            return this.getEventType();
        }
        throw new NoSuchElementException("There is no any next event");
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        try {
            this.tokenType = this.jsonReader.peek();
            return this.tokenType != JsonToken.END_DOCUMENT;
        }
        catch (IOException e) {
            throw new XMLStreamException("Unexpected end of json stream");
        }
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.isStartElement() || this.isEndElement()) {
            return this.namespace;
        }
        return null;
    }

    @Override
    public boolean isStartElement() {
        return this.state == JsonState.NameName || this.state == JsonState.NameValue || this.state == JsonState.ValueValue_CHAR || this.state == JsonState.EndObjectBeginObject_START;
    }

    @Override
    public boolean isEndElement() {
        return this.state == JsonState.ValueValue_START || this.state == JsonState.EndArrayName || this.state == JsonState.ValueEndObject_END_2 || this.state == JsonState.ValueName_START || this.state == JsonState.EndObjectName || this.state == JsonState.EndObjectBeginObject_END || this.state == JsonState.EndArrayEndObject || this.state == JsonState.EndObjectEndObject;
    }

    @Override
    public boolean isCharacters() {
        return this.state == JsonState.ValueValue_END || this.state == JsonState.ValueEndArray || this.state == JsonState.ValueEndObject_END_1 || this.state == JsonState.ValueName_END;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int getAttributeCount() {
        if (this.isStartElement()) {
            return 0;
        }
        throw new IllegalStateException("Only valid on START_ELEMENT state");
    }

    @Override
    public QName getAttributeName(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getAttributeNamespace(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getAttributeLocalName(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getAttributePrefix(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getAttributeType(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getAttributeValue(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int getNamespaceCount() {
        if (this.isStartElement() || this.isEndElement()) {
            return 1;
        }
        throw new IllegalStateException("only valid on a START_ELEMENT or END_ELEMENT state");
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (this.isStartElement() || this.isEndElement()) {
            return null;
        }
        throw new IllegalStateException("only valid on a START_ELEMENT or END_ELEMENT state");
    }

    @Override
    public String getNamespaceURI(int index) {
        if (this.isStartElement() || this.isEndElement()) {
            return this.namespace;
        }
        throw new IllegalStateException("only valid on a START_ELEMENT or END_ELEMENT state");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int getEventType() {
        if (this.state == JsonState.StartState) {
            return 7;
        }
        if (this.isStartElement()) {
            return 1;
        }
        if (this.isCharacters()) {
            return 4;
        }
        if (this.isEndElement()) {
            return 2;
        }
        if (this.state == JsonState.EndObjectEndDocument) {
            return 8;
        }
        return 0;
    }

    @Override
    public String getText() {
        if (this.isCharacters()) {
            return this.value;
        }
        return null;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.isCharacters()) {
            if (this.value == null) {
                return new char[0];
            }
            return this.value.toCharArray();
        }
        throw new IllegalStateException("This is not a valid state");
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int getTextStart() {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public int getTextLength() {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.isCharacters();
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        if (this.isStartElement() || this.isEndElement()) {
            return new QName(this.namespace, this.localName);
        }
        throw new IllegalStateException("getName method is valid only for the START_ELEMENT or END_ELEMENT event");
    }

    @Override
    public String getLocalName() {
        int i = this.getEventType();
        if (i == 1 || i == 2) {
            return this.localName;
        }
        throw new IllegalStateException("To get local name state should be START_ELEMENT or END_ELEMENT");
    }

    @Override
    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    @Override
    public String getNamespaceURI() {
        if (this.isStartElement() || this.isEndElement()) {
            return this.namespace;
        }
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    private void stateTransition() throws XMLStreamException, IOException {
        if (this.state == JsonState.StartState) {
            this.beginObject();
            JsonObject topElement = new JsonObject("StackTopElement", JSONType.NESTED_OBJECT, null, "http://axis2.apache.org/axis/json");
            this.stackObj.push(topElement);
            this.readName();
        } else if (this.state == JsonState.NameName) {
            this.readName();
        } else if (this.state == JsonState.NameValue) {
            this.readValue();
        } else if (this.state == JsonState.ValueEndObject_END_1) {
            this.state = JsonState.ValueEndObject_END_2;
            this.removeStackObj();
        } else if (this.state == JsonState.ValueEndObject_END_2) {
            this.readEndObject();
        } else if (this.state == JsonState.ValueName_END) {
            this.state = JsonState.ValueName_START;
            this.removeStackObj();
        } else if (this.state == JsonState.ValueName_START) {
            this.readName();
        } else if (this.state == JsonState.ValueValue_END) {
            this.state = JsonState.ValueValue_START;
        } else if (this.state == JsonState.ValueValue_START) {
            this.value = null;
            this.state = JsonState.ValueValue_CHAR;
        } else if (this.state == JsonState.ValueValue_CHAR) {
            this.readValue();
        } else if (this.state == JsonState.ValueEndArray) {
            this.readEndArray();
            this.removeStackObj();
        } else if (this.state == JsonState.EndArrayName) {
            this.readName();
        } else if (this.state == JsonState.EndObjectEndObject) {
            this.readEndObject();
        } else if (this.state == JsonState.EndObjectName) {
            this.readName();
        } else if (this.state == JsonState.EndObjectBeginObject_END) {
            this.state = JsonState.EndObjectBeginObject_START;
            this.fillMiniStack();
        } else if (this.state == JsonState.EndObjectBeginObject_START) {
            this.readBeginObject();
        } else if (this.state == JsonState.EndArrayEndObject) {
            this.readEndObject();
        }
    }

    private void removeStackObj() throws XMLStreamException {
        if (!this.stackObj.empty()) {
            if (this.topNestedArrayObj == null) {
                this.stackObj.pop();
            } else if (this.stackObj.peek().equals(this.topNestedArrayObj)) {
                this.topNestedArrayObj = null;
                this.processedJsonObject.clear();
                this.stackObj.pop();
            } else {
                this.processedJsonObject.push(this.stackObj.pop());
            }
            this.localName = !this.stackObj.empty() ? this.stackObj.peek().getName() : "";
        } else {
            System.out.println("stackObj is empty");
            throw new XMLStreamException("Error while processing input JSON stream, JSON request may not valid , it may has more end object characters ");
        }
    }

    private void fillMiniStack() {
        this.miniStack.clear();
        JsonObject nestedArray = this.stackObj.peek();
        while (!this.processedJsonObject.peek().equals(nestedArray)) {
            this.miniStack.push(this.processedJsonObject.pop());
        }
    }

    private void readName() throws IOException, XMLStreamException {
        this.nextName();
        this.tokenType = this.jsonReader.peek();
        if (this.tokenType == JsonToken.BEGIN_OBJECT) {
            this.beginObject();
            this.state = JsonState.NameName;
        } else if (this.tokenType == JsonToken.BEGIN_ARRAY) {
            this.beginArray();
            this.tokenType = this.jsonReader.peek();
            if (this.tokenType == JsonToken.BEGIN_OBJECT) {
                this.beginObject();
                this.state = JsonState.NameName;
            } else {
                this.state = JsonState.NameValue;
            }
        } else if (this.tokenType == JsonToken.STRING || this.tokenType == JsonToken.NUMBER || this.tokenType == JsonToken.BOOLEAN || this.tokenType == JsonToken.NULL) {
            this.state = JsonState.NameValue;
        }
    }

    private void readValue() throws IOException {
        this.nextValue();
        this.tokenType = this.jsonReader.peek();
        if (this.tokenType == JsonToken.NAME) {
            this.state = JsonState.ValueName_END;
        } else if (this.tokenType == JsonToken.STRING || this.tokenType == JsonToken.NUMBER || this.tokenType == JsonToken.BOOLEAN || this.tokenType == JsonToken.NULL) {
            this.state = JsonState.ValueValue_END;
        } else if (this.tokenType == JsonToken.END_ARRAY) {
            this.state = JsonState.ValueEndArray;
        } else if (this.tokenType == JsonToken.END_OBJECT) {
            this.state = JsonState.ValueEndObject_END_1;
        }
    }

    private void readBeginObject() throws IOException, XMLStreamException {
        this.beginObject();
        this.readName();
    }

    private void readEndObject() throws IOException, XMLStreamException {
        this.endObject();
        this.tokenType = this.jsonReader.peek();
        if (this.tokenType == JsonToken.END_OBJECT) {
            this.removeStackObj();
            this.state = JsonState.EndObjectEndObject;
        } else if (this.tokenType == JsonToken.END_ARRAY) {
            this.readEndArray();
            this.removeStackObj();
        } else if (this.tokenType == JsonToken.NAME) {
            this.removeStackObj();
            this.state = JsonState.EndObjectName;
        } else if (this.tokenType == JsonToken.BEGIN_OBJECT) {
            this.state = JsonState.EndObjectBeginObject_END;
        } else if (this.tokenType == JsonToken.END_DOCUMENT) {
            this.removeStackObj();
            this.state = JsonState.EndObjectEndDocument;
        }
    }

    private void readEndArray() throws IOException {
        this.endArray();
        this.tokenType = this.jsonReader.peek();
        if (this.tokenType == JsonToken.END_OBJECT) {
            this.state = JsonState.EndArrayEndObject;
        } else if (this.tokenType == JsonToken.NAME) {
            this.state = JsonState.EndArrayName;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextName() throws IOException, XMLStreamException {
        String name = this.jsonReader.nextName();
        if (!this.miniStack.empty()) {
            JsonObject jsonObj = this.miniStack.peek();
            if (!jsonObj.getName().equals(name)) throw new XMLStreamException("Input JSON message is not valid expected : " + jsonObj.getName() + " but found : " + name);
            this.namespace = jsonObj.getNamespaceUri();
            this.stackObj.push(this.miniStack.pop());
        } else {
            if (this.queue.isEmpty()) throw new XMLStreamException("Input JSON message is not valid ");
            JsonObject jsonObj = this.queue.peek();
            if (!jsonObj.getName().equals(name)) throw new XMLStreamException("Input JSON message is not valid expected : " + jsonObj.getName() + " but found : " + name);
            this.namespace = jsonObj.getNamespaceUri();
            this.stackObj.push(this.queue.poll());
        }
        this.localName = this.stackObj.peek().getName();
        this.value = null;
    }

    private String nextValue() {
        block13: {
            try {
                this.tokenType = this.jsonReader.peek();
                if (this.tokenType == JsonToken.STRING) {
                    this.value = this.jsonReader.nextString();
                    break block13;
                }
                if (this.tokenType == JsonToken.BOOLEAN) {
                    this.value = String.valueOf(this.jsonReader.nextBoolean());
                    break block13;
                }
                if (this.tokenType == JsonToken.NUMBER) {
                    JsonObject peek = this.stackObj.peek();
                    String valueType = peek.getValueType();
                    if (valueType.equals("int")) {
                        this.value = String.valueOf(this.jsonReader.nextInt());
                    } else if (valueType.equals("long")) {
                        this.value = String.valueOf(this.jsonReader.nextLong());
                    } else if (valueType.equals("double")) {
                        this.value = String.valueOf(this.jsonReader.nextDouble());
                    } else if (valueType.equals("float")) {
                        this.value = String.valueOf(this.jsonReader.nextDouble());
                    }
                    break block13;
                }
                if (this.tokenType == JsonToken.NULL) {
                    this.jsonReader.nextNull();
                    this.value = null;
                    break block13;
                }
                log.error((Object)"Couldn't read the value, Illegal state exception");
                throw new RuntimeException("Couldn't read the value, Illegal state exception");
            }
            catch (IOException e) {
                log.error((Object)"IO error while reading json stream");
                throw new RuntimeException("IO error while reading json stream");
            }
        }
        return this.value;
    }

    private void beginObject() throws IOException {
        this.jsonReader.beginObject();
    }

    private void beginArray() throws IOException {
        this.jsonReader.beginArray();
        if (this.stackObj.peek().getType() == JSONType.NESTED_ARRAY) {
            if (this.topNestedArrayObj == null) {
                this.topNestedArrayObj = this.stackObj.peek();
            }
            this.processedJsonObject.push(this.stackObj.peek());
        }
    }

    private void endObject() throws IOException {
        this.jsonReader.endObject();
    }

    private void endArray() throws IOException {
        this.jsonReader.endArray();
        if (this.stackObj.peek().equals(this.topNestedArrayObj)) {
            this.topNestedArrayObj = null;
        }
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public static enum JsonState {
        StartState,
        NameValue,
        NameName,
        ValueValue_END,
        ValueValue_START,
        ValueValue_CHAR,
        ValueEndArray,
        ValueEndObject_END_1,
        ValueEndObject_END_2,
        ValueName_END,
        ValueName_START,
        EndObjectEndObject,
        EndObjectName,
        EndArrayName,
        EndArrayEndObject,
        EndObjectBeginObject_END,
        EndObjectBeginObject_START,
        EndObjectEndDocument;

    }
}

