/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson.rpc;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);

    public static Object invokeServiceClass(JsonReader jsonReader, Object service, Method operation, Class[] paramClasses, int paramCount, String enableJSONOnly) throws InvocationTargetException, IllegalAccessException, IOException {
        Object[] methodParam = new Object[paramCount];
        try {
            Gson gson = new Gson();
            String[] argNames = new String[paramCount];
            if (!jsonReader.isLenient()) {
                jsonReader.setLenient(true);
            }
            if (enableJSONOnly == null || enableJSONOnly.equalsIgnoreCase("false")) {
                log.debug((Object)("JsonUtils.invokeServiceClass() detected enableJSONOnly=false, executing jsonReader.beginObject() and then jsonReader.beginArray() on method name: " + operation.getName()));
                jsonReader.beginObject();
                String messageName = jsonReader.nextName();
                if (messageName == null || !messageName.equals(operation.getName())) {
                    log.error((Object)("JsonUtils.invokeServiceClass() throwing IOException, messageName: " + messageName + " is unknown, it does not match the axis2 operation, the method name: " + operation.getName()));
                    throw new IOException("Bad Request");
                }
            } else {
                log.debug((Object)"JsonUtils.invokeServiceClass() detected enableJSONOnly=true, executing jsonReader.beginArray()");
            }
            jsonReader.beginArray();
            int i = 0;
            for (Class paramType : paramClasses) {
                jsonReader.beginObject();
                argNames[i] = jsonReader.nextName();
                methodParam[i] = gson.fromJson(jsonReader, (Type)paramType);
                log.trace((Object)("JsonUtils.invokeServiceClass() completed processing on argNames: " + argNames[i] + " , methodParam: " + methodParam[i].getClass().getName() + " , from argNames.length: " + argNames.length));
                jsonReader.endObject();
                ++i;
            }
            jsonReader.endArray();
            jsonReader.endObject();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IOException("Bad Request");
        }
        return operation.invoke(service, methodParam);
    }

    public static Method getOpMethod(String methodName, Method[] methodSet) {
        for (Method method : methodSet) {
            String mName = method.getName();
            if (!mName.equals(methodName)) continue;
            log.debug((Object)("JsonUtils.getOpMethod() returning methodName: " + methodName));
            return method;
        }
        log.debug((Object)"JsonUtils.getOpMethod() returning null");
        return null;
    }
}

