/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import org.apache.axis2.databinding.types.NonPositiveInteger;

public class NegativeInteger
extends NonPositiveInteger {
    private static final long serialVersionUID = -2295928715693639427L;
    private BigInteger zero = new BigInteger("0");

    public NegativeInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public NegativeInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public NegativeInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public NegativeInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public NegativeInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public NegativeInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.zero) >= 0) {
            throw new NumberFormatException(":  " + String.valueOf(this));
        }
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return new BigIntegerRep(this.toByteArray());
    }

    protected static class BigIntegerRep
    implements Serializable {
        private static final long serialVersionUID = 1209618487031404110L;
        private byte[] array;

        protected BigIntegerRep(byte[] array) {
            this.array = array;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new NegativeInteger(this.array);
        }
    }
}

