/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.axis2.classloader.BeanInfoCache;
import org.apache.axis2.classloader.BeanInfoCachingClassLoader;

public class DeploymentClassLoader
extends URLClassLoader
implements BeanInfoCachingClassLoader {
    private boolean isChildFirstClassLoading;
    private final BeanInfoCache beanInfoCache = new BeanInfoCache();

    public DeploymentClassLoader(URL[] urls, ClassLoader parent, boolean isChildFirstClassLoading) {
        super(urls, parent);
        this.isChildFirstClassLoading = isChildFirstClassLoading;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getResource(name);
        }
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        if (!this.isChildFirstClassLoading) {
            c = super.loadClass(name, resolve);
        } else {
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (Exception e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        return c;
    }

    public boolean isChildFirstClassLoading() {
        return this.isChildFirstClassLoading;
    }

    public void setChildFirstClassLoading(boolean childFirstClassLoading) {
        this.isChildFirstClassLoading = childFirstClassLoading;
    }

    @Override
    public final BeanInfoCache getBeanInfoCache() {
        return this.beanInfoCache;
    }
}

