/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxrs;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.axis2.jaxrs.JAXRSModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRSUtils {
    private static Log log = LogFactory.getLog(JAXRSModel.class);

    public static JAXRSModel getClassModel(Class serviceClass) {
        Annotation[] annotation;
        JAXRSModel model = new JAXRSModel();
        for (Annotation a : annotation = serviceClass.getAnnotations()) {
            if (a == null) continue;
            if (a instanceof Produces) {
                JAXRSUtils.addProducesToClassModel((Produces)a, model);
                continue;
            }
            if (a instanceof Consumes) {
                JAXRSUtils.addConsumesToClassModel((Consumes)a, model);
                continue;
            }
            if (a instanceof Path) {
                JAXRSUtils.addPathToClassModel((Path)a, model);
                continue;
            }
            System.out.println("Could not identify the Annotation....");
        }
        return model;
    }

    public static JAXRSModel getMethodModel(JAXRSModel classModel, Method serviceMethod) {
        Annotation[] annotation;
        JAXRSModel model = new JAXRSModel();
        JAXRSUtils.addProducesToMethodModel(classModel, model);
        JAXRSUtils.addConsumesToMethodModel(classModel, model);
        JAXRSUtils.addPathToMethodModel(classModel, model);
        for (Annotation a : annotation = serviceMethod.getAnnotations()) {
            if (a == null) continue;
            if (a instanceof Produces) {
                JAXRSUtils.addProducesToMethodModel((Produces)a, model);
                continue;
            }
            if (a instanceof Consumes) {
                JAXRSUtils.addConsumesToMethodModel((Consumes)a, model);
                continue;
            }
            if (a instanceof Path) {
                JAXRSUtils.addPathToMethodModel((Path)a, model);
                continue;
            }
            JAXRSUtils.addHTTPMethodToMethodModel(a, model);
        }
        return model;
    }

    private static void addProducesToClassModel(Produces produces, JAXRSModel classModel) {
        String[] array = null;
        Object value = null;
        for (String s : array = produces.value()) {
            value = value == null ? s : (String)value + "," + s;
        }
        classModel.setProduces((String)value);
    }

    private static void addConsumesToClassModel(Consumes consumes, JAXRSModel classModel) {
        String[] array = null;
        Object value = null;
        for (String s : array = consumes.value()) {
            value = value == null ? s : (String)value + "," + s;
        }
        classModel.setConsumes((String)value);
    }

    private static void addPathToClassModel(Path path, JAXRSModel classModel) {
        String value = null;
        value = path.value();
        if (value != null) {
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        classModel.setPath(value);
    }

    private static void addProducesToMethodModel(Produces produces, JAXRSModel methodModel) {
        Object value = null;
        for (String s : produces.value()) {
            value = value != null ? (String)value + s : s;
            methodModel.setProduces((String)value);
        }
    }

    private static void addProducesToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getProduces();
        if (value != null) {
            methodModel.setProduces(value);
        }
    }

    private static void addConsumesToMethodModel(Consumes consumes, JAXRSModel methodModel) {
        Object value = null;
        for (String s : consumes.value()) {
            value = value != null ? (String)value + s : s;
            methodModel.setConsumes((String)value);
        }
    }

    private static void addConsumesToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getConsumes();
        if (value != null) {
            methodModel.setConsumes(value);
        }
    }

    private static void addHTTPMethodToMethodModel(Annotation annotation, JAXRSModel methodModel) {
        if (annotation instanceof POST) {
            methodModel.setHTTPMethod("POST");
        } else if (annotation instanceof GET) {
            methodModel.setHTTPMethod("GET");
        } else if (annotation instanceof PUT) {
            methodModel.setHTTPMethod("PUT");
        } else if (annotation instanceof DELETE) {
            methodModel.setHTTPMethod("DELETE");
        } else if (annotation instanceof HEAD) {
            log.warn((Object)"HTTP Method HEAD is not supported by AXIS2");
        }
    }

    private static void addPathToMethodModel(Path path, JAXRSModel methodModel) {
        String value = path.value();
        if (value != null) {
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        if (methodModel.getPath() != null) {
            methodModel.setPath(methodModel.getPath() + "/" + value);
        } else {
            methodModel.setPath(value);
        }
    }

    private static void addPathToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getPath();
        if (value != null) {
            methodModel.setPath(value);
        }
    }
}

