/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNamespaceDeclaration;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.OMNamespaceCache;
import org.apache.axiom.om.impl.dom.CoreAttributeImpl;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactoryImpl;
import org.apache.axiom.om.impl.dom.intf.DOOMAttribute;
import org.apache.axiom.om.impl.dom.intf.DOOMNamespaceDeclaration;
import org.apache.axiom.om.impl.dom.intf.DOOMParentNode;
import org.apache.axiom.om.impl.intf.AxiomInformationItem;
import org.apache.axiom.om.impl.intf.AxiomNamespaceDeclaration;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.w3c.dom.DOMException;

public final class DOOMNamespaceDeclarationImpl
extends CoreAttributeImpl
implements DOOMNamespaceDeclaration,
DOOMAttribute,
DOOMParentNode,
DOMNamespaceDeclaration,
AxiomNamespaceDeclaration,
AxiomInformationItem,
OMInformationItem {
    private static final OMNamespace DEFAULT_NS = new OMNamespaceImpl("", "");
    private OMNamespace declaredNamespace;

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.NAMESPACE_DECLARATION;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        this.coreSetDeclaredNamespace(((CoreNamespaceDeclaration)other).coreGetDeclaredPrefix(), "");
    }

    @Override
    public final void internalSerialize(XmlHandler handler, boolean cache) throws CoreModelException, StreamException {
        handler.processNamespaceDeclaration(this.coreGetDeclaredPrefix(), this.coreGetCharacterData().toString());
    }

    @Override
    public final String getNamespaceURI() {
        return "http://www.w3.org/2000/xmlns/";
    }

    @Override
    public final String getPrefix() {
        return this.coreGetDeclaredPrefix().length() == 0 ? null : "xmlns";
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    @Override
    public final String getLocalName() {
        String declaredPrefix = this.coreGetDeclaredPrefix();
        return declaredPrefix.length() == 0 ? "xmlns" : declaredPrefix;
    }

    @Override
    public final String getName() {
        String declaredPrefix = this.coreGetDeclaredPrefix();
        if (declaredPrefix.length() == 0) {
            return "xmlns";
        }
        return "xmlns:" + declaredPrefix;
    }

    @Override
    public final boolean isId() {
        return false;
    }

    @Override
    public final void init(String prefix, String namespaceURI, Object namespaceHelper) {
        OMNamespace ns = ((OMNamespaceCache)namespaceHelper).getOMNamespace(namespaceURI, prefix);
        this.setDeclaredNamespace(ns == null ? DEFAULT_NS : ns);
    }

    @Override
    public final String coreGetDeclaredPrefix() {
        return this.declaredNamespace.getPrefix();
    }

    @Override
    public final OMNamespace getDeclaredNamespace() {
        try {
            String namespaceURI = this.coreGetCharacterData().toString();
            if (!namespaceURI.equals(this.declaredNamespace.getNamespaceURI())) {
                this.declaredNamespace = new OMNamespaceImpl(namespaceURI, this.declaredNamespace.getPrefix());
            }
            return this.declaredNamespace;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void coreSetDeclaredNamespace(String prefix, String namespaceURI) {
        this.setDeclaredNamespace(new OMNamespaceImpl(namespaceURI, prefix));
    }

    @Override
    public final void setDeclaredNamespace(OMNamespace declaredNamespace) {
        try {
            this.declaredNamespace = declaredNamespace;
            this.coreSetCharacterData(declaredNamespace.getNamespaceURI(), AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void build() {
    }

    public OMFactory getOMFactory() {
        return this.getMetaFactory().getOMFactory();
    }

    public final OMInformationItem clone(OMCloneOptions options) {
        try {
            return (OMInformationItem)this.coreClone(AxiomSemantics.CLONE_POLICY, options);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final AxiomNodeFactory getNodeFactory() {
        return DOOMNodeFactoryImpl.INSTANCE;
    }

    @Override
    public final OMMetaFactory getMetaFactory() {
        return DOOMNodeFactoryImpl.INSTANCE;
    }
}

