/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.OutputStream;
import org.apache.axiom.util.base64.Base64EncodingOutputStream;

public abstract class ContentTransferEncoding {
    public static final ContentTransferEncoding EIGHT_BIT = new Identity("8bit");
    public static final ContentTransferEncoding BINARY = new Identity("binary");
    public static final ContentTransferEncoding BASE64 = new ContentTransferEncoding("base64"){

        @Override
        public OutputStream encode(OutputStream out) {
            return new Base64EncodingOutputStream(out);
        }
    };
    private final String name;

    public ContentTransferEncoding(String name) {
        this.name = name;
    }

    public final String toString() {
        return this.name;
    }

    public abstract OutputStream encode(OutputStream var1);

    private static class Identity
    extends ContentTransferEncoding {
        Identity(String name) {
            super(name);
        }

        @Override
        public OutputStream encode(OutputStream out) {
            return out;
        }
    }
}

