/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.util.stax.dialect.AbstractStAXDialect;
import org.apache.axiom.util.stax.dialect.NormalizingXMLInputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.StAXDialectUtils;
import org.apache.axiom.util.stax.dialect.Woodstox4OutputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.Woodstox4StreamReaderWrapper;
import org.apache.axiom.util.stax.dialect.Woodstox4StreamWriterWrapper;

class Woodstox4Dialect
extends AbstractStAXDialect {
    public static final Woodstox4Dialect INSTANCE = new Woodstox4Dialect();

    private Woodstox4Dialect() {
    }

    @Override
    public String getName() {
        return "Woodstox";
    }

    @Override
    public XMLInputFactory enableCDataReporting(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        factory.setProperty("com.ctc.wstx.minTextSegment", Integer.MAX_VALUE);
        return factory;
    }

    @Override
    public XMLInputFactory disallowDoctypeDecl(XMLInputFactory factory) {
        return StAXDialectUtils.disallowDoctypeDecl(factory);
    }

    @Override
    public XMLInputFactory makeThreadSafe(XMLInputFactory factory) {
        return factory;
    }

    @Override
    public XMLOutputFactory makeThreadSafe(XMLOutputFactory factory) {
        return factory;
    }

    @Override
    public XMLStreamReader normalize(XMLStreamReader reader) {
        return new Woodstox4StreamReaderWrapper(reader);
    }

    @Override
    public XMLStreamWriter normalize(XMLStreamWriter writer) {
        return new Woodstox4StreamWriterWrapper(writer);
    }

    @Override
    public XMLInputFactory normalize(XMLInputFactory factory) {
        factory.setProperty("org.codehaus.stax2.reportPrologWhitespace", Boolean.TRUE);
        return new NormalizingXMLInputFactoryWrapper(factory, this);
    }

    @Override
    public XMLOutputFactory normalize(XMLOutputFactory factory) {
        factory.setProperty("com.ctc.wstx.outputFixContent", Boolean.TRUE);
        return new Woodstox4OutputFactoryWrapper(factory, this);
    }
}

