/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.mixin;

import javax.xml.namespace.QName;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPCloneOptions;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.common.SOAPHeaderBlockHelper;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;
import org.apache.axiom.soap.impl.intf.SOAPHelper;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomSOAPHeaderBlockMixin
implements AxiomSOAPHeaderBlock {
    private boolean processed;

    @Override
    public final boolean isChildElementAllowed(OMElement child) {
        return true;
    }

    public final SOAPVersion getVersion() {
        return this.getSOAPHelper().getVersion();
    }

    public final boolean isProcessed() {
        return this.processed;
    }

    public final void setProcessed() {
        this.processed = true;
    }

    public final boolean getMustUnderstand() throws SOAPProcessingException {
        return SOAPHeaderBlockHelper.getMustUnderstand(this, this.getSOAPHelper());
    }

    public final void setMustUnderstand(boolean mustUnderstand) {
        SOAPHelper helper = this.getSOAPHelper();
        this._setAttributeValue(helper.getMustUnderstandAttributeQName(), helper.formatBoolean(mustUnderstand));
    }

    public final String getRole() {
        return SOAPHeaderBlockHelper.getRole(this, this.getSOAPHelper());
    }

    public final void setRole(String role) {
        this._setAttributeValue(this.getSOAPHelper().getRoleAttributeQName(), role);
    }

    public final boolean getRelay() {
        SOAPHelper helper = this.getSOAPHelper();
        QName attributeQName = helper.getRelayAttributeQName();
        if (attributeQName == null) {
            throw new UnsupportedOperationException("Not supported for " + helper.getSpecName());
        }
        return SOAPHeaderBlockHelper.getBooleanAttributeValue(this, helper, "org.apache.axiom.soap.SOAPHeader.RELAY", attributeQName);
    }

    public final void setRelay(boolean relay) {
        SOAPHelper helper = this.getSOAPHelper();
        QName attributeQName = helper.getRelayAttributeQName();
        if (attributeQName == null) {
            throw new UnsupportedOperationException("Not supported for " + helper.getSpecName());
        }
        this._setAttributeValue(attributeQName, helper.formatBoolean(relay));
    }

    @Override
    public final <T> void initAncillaryData(ClonePolicy<T> policy, T options, CoreNode other) {
        Boolean processedFlag;
        Boolean bl = processedFlag = options instanceof SOAPCloneOptions ? ((SOAPCloneOptions)options).getProcessedFlag() : null;
        if (processedFlag == null && ((SOAPHeaderBlock)other).isProcessed() || processedFlag != null && processedFlag.booleanValue()) {
            this.setProcessed();
        }
    }
}

