/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.ExtendedPolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAP11Constants;
import org.apache.wss4j.dom.SOAP12Constants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyBasedResultsValidator
implements ExtendedPolicyValidatorCallbackHandler {
    private static Log log = LogFactory.getLog(PolicyBasedResultsValidator.class);

    @Override
    public void validate(ValidatorData data, Vector results) throws RampartException {
        ArrayList<WSSecurityEngineResult> resultsList = new ArrayList<WSSecurityEngineResult>(results);
        this.validate(data, resultsList);
    }

    @Override
    public void validate(ValidatorData data, List<WSSecurityEngineResult> results) throws RampartException {
        Timestamp timestamp;
        X509Certificate returnCert;
        WSSecurityEngineResult actionResult;
        RampartMessageData rmd = data.getRampartMessageData();
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd != null && results == null) {
            throw new RampartException("noSecurityResults");
        }
        WSSecurityEngineResult tsResult = null;
        if (rpd != null && rpd.isIncludeTimestamp() && (tsResult = PolicyBasedResultsValidator.fetchActionResult(results, 32)) == null && !rpd.isIncludeTimestampOptional()) {
            throw new RampartException("timestampMissing");
        }
        List<WSEncryptionPart> encryptedParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd != null && rpd.isSignatureProtection() && this.isSignatureRequired(rmd)) {
            String sigId = RampartUtil.getSigElementId(rmd);
            encryptedParts.add(RampartUtil.createEncryptionPart("Signature", sigId, "http://www.w3.org/2000/09/xmldsig#", "Element"));
        }
        List<WSEncryptionPart> signatureParts = RampartUtil.getSignedParts(rmd);
        if (!(rpd == null || tsResult == null && rpd.isIncludeTimestampOptional() || !rpd.isIncludeTimestamp() || rpd.isTransportBinding())) {
            signatureParts.add(RampartUtil.createEncryptionPart("Timestamp", "timestamp"));
        }
        if (!rmd.isInitiator()) {
            SignedEncryptedParts sgndEndSignedParts;
            SignedEncryptedParts endSignedParts;
            SupportingToken endSupportingToken = null;
            if (rpd != null) {
                endSupportingToken = rpd.getEndorsingSupportingTokens();
            }
            if (endSupportingToken != null && !endSupportingToken.isOptional() && ((endSignedParts = endSupportingToken.getSignedParts()) != null && !endSignedParts.isOptional() && (endSignedParts.isBody() || endSignedParts.getHeaders().size() > 0) || rpd.isIncludeTimestamp())) {
                signatureParts.add(RampartUtil.createEncryptionPart("EndorsingSupportingTokens", "EndorsingSupportingTokens"));
            }
            SupportingToken sgndEndSupportingToken = null;
            if (rpd != null) {
                sgndEndSupportingToken = rpd.getSignedEndorsingSupportingTokens();
            }
            if (sgndEndSupportingToken != null && !sgndEndSupportingToken.isOptional() && ((sgndEndSignedParts = sgndEndSupportingToken.getSignedParts()) != null && !sgndEndSignedParts.isOptional() && (sgndEndSignedParts.isBody() || sgndEndSignedParts.getHeaders().size() > 0) || rpd.isIncludeTimestamp())) {
                signatureParts.add(RampartUtil.createEncryptionPart("SignedEndorsingSupportingTokens", "SignedEndorsingSupportingTokens"));
            }
            if (rpd != null) {
                List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
                for (SupportingToken supportingToken : supportingToks) {
                    if (supportingToken == null || supportingToken.isOptional()) continue;
                    SupportingPolicyData policyData = new SupportingPolicyData();
                    policyData.build(supportingToken);
                    encryptedParts.addAll(RampartUtil.getSupportingEncryptedParts(rmd, policyData));
                    signatureParts.addAll(RampartUtil.getSupportingSignedParts(rmd, policyData));
                }
            }
        }
        this.validateEncrSig(data, encryptedParts, signatureParts, results);
        if (rpd != null && !rpd.isTransportBinding()) {
            this.validateProtectionOrder(data, results);
        }
        this.validateEncryptedParts(data, encryptedParts, results);
        this.validateSignedPartsHeaders(data, signatureParts, results);
        this.validateRequiredElements(data);
        if (!rmd.isInitiator()) {
            this.validateSupportingTokens(data, results);
        }
        if ((actionResult = PolicyBasedResultsValidator.fetchActionResult(results, 2)) != null && (returnCert = (X509Certificate)actionResult.get((Object)"x509-certificate")) != null && !this.verifyTrust(returnCert, rmd)) {
            throw new RampartException("trustVerificationError");
        }
        actionResult = PolicyBasedResultsValidator.fetchActionResult(results, 32);
        if (actionResult != null && (timestamp = (Timestamp)actionResult.get((Object)"timestamp")) != null && !this.verifyTimestamp(timestamp, rmd)) {
            throw new RampartException("cannotValidateTimestamp");
        }
    }

    protected void validateEncrSig(ValidatorData data, List<WSEncryptionPart> encryptedParts, List<WSEncryptionPart> signatureParts, List<WSSecurityEngineResult> results) throws RampartException {
        List<Integer> actions = this.getSigEncrActions(results);
        boolean sig = false;
        boolean encr = false;
        for (Integer action : actions) {
            Integer act = action;
            if (act == 2) {
                sig = true;
                continue;
            }
            if (act != 4) continue;
            encr = true;
        }
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        SupportingToken sgndSupTokens = rpd.getSignedSupportingTokens();
        SupportingToken sgndEndorSupTokens = rpd.getSignedEndorsingSupportingTokens();
        if (!(!sig || signatureParts.size() != 0 || sgndSupTokens != null && sgndSupTokens.getTokens().size() != 0 || sgndEndorSupTokens != null && sgndEndorSupTokens.getTokens().size() != 0)) {
            throw new RampartException("unexprectedSignature");
        }
        if (!sig && signatureParts.size() > 0) {
            throw new RampartException("signatureMissing");
        }
        if (encr && encryptedParts.size() == 0) {
            List<WSSecurityEngineResult> list = this.getResults(results, 4);
            boolean encrDataFound = false;
            for (WSSecurityEngineResult result : list) {
                ArrayList dataRefURIs;
                Object resultElement = result.get((Object)"data-ref-uris");
                if (!(resultElement instanceof ArrayList) || (dataRefURIs = (ArrayList)resultElement) == null || dataRefURIs.size() == 0) continue;
                encrDataFound = true;
            }
            if (encrDataFound && !this.isUsernameTokenPresent(data)) {
                throw new RampartException("unexprectedEncryptedPart");
            }
        } else if (!encr && encryptedParts.size() > 0) {
            throw new RampartException("encryptionMissing");
        }
    }

    protected void validateSupportingTokens(ValidatorData data, List<WSSecurityEngineResult> results) throws RampartException {
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        RampartMessageData rmd = data.getRampartMessageData();
        List<SupportingToken> supportingTokens = rpd.getSupportingTokensList();
        for (SupportingToken suppTok : supportingTokens) {
            this.handleSupportingTokens(rmd, results, suppTok);
        }
        SupportingToken signedSuppToken = rpd.getSignedSupportingTokens();
        this.handleSupportingTokens(rmd, results, signedSuppToken);
        SupportingToken signedEndSuppToken = rpd.getSignedEndorsingSupportingTokens();
        this.handleSupportingTokens(rmd, results, signedEndSuppToken);
        SupportingToken endSuppToken = rpd.getEndorsingSupportingTokens();
        this.handleSupportingTokens(rmd, results, endSuppToken);
    }

    protected void handleSupportingTokens(RampartMessageData rmd, List<WSSecurityEngineResult> results, SupportingToken suppTok) throws RampartException {
        if (suppTok == null) {
            return;
        }
        ArrayList tokens = suppTok.getTokens();
        for (Object objectToken : tokens) {
            Token token = (Token)objectToken;
            if (token instanceof UsernameToken) {
                UsernameToken ut = (UsernameToken)token;
                WSSecurityEngineResult utResult = PolicyBasedResultsValidator.fetchActionResult(results, 1);
                if (utResult == null && !ut.isOptional()) {
                    throw new RampartException("usernameTokenMissing");
                }
                org.apache.wss4j.dom.message.token.UsernameToken wssUt = (org.apache.wss4j.dom.message.token.UsernameToken)utResult.get((Object)"username-token");
                if (ut.isNoPassword() && wssUt.getPassword() != null) {
                    throw new RampartException("invalidUsernameTokenType");
                }
                if (ut.isHashPassword() && !wssUt.isHashed()) {
                    throw new RampartException("invalidUsernameTokenType");
                }
                if (ut.isHashPassword() || wssUt.getPassword() != null && wssUt.getPasswordType().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) continue;
                throw new RampartException("invalidUsernameTokenType");
            }
            if (token instanceof IssuedToken) {
                WSSecurityEngineResult samlResult = PolicyBasedResultsValidator.fetchActionResult(results, 16);
                if (samlResult == null) {
                    log.debug((Object)"No signed SAMLToken found. Looking for unsigned SAMLTokens");
                    samlResult = PolicyBasedResultsValidator.fetchActionResult(results, 8);
                }
                if (samlResult != null) continue;
                throw new RampartException("samlTokenMissing");
            }
            if (!(token instanceof X509Token)) continue;
            X509Token x509Token = (X509Token)token;
            WSSecurityEngineResult x509Result = PolicyBasedResultsValidator.fetchActionResult(results, 4096);
            if (x509Result != null || x509Token.isOptional()) continue;
            throw new RampartException("binaryTokenMissing");
        }
    }

    protected void validateProtectionOrder(ValidatorData data, List<WSSecurityEngineResult> results) throws RampartException {
        String protectionOrder = data.getRampartMessageData().getPolicyData().getProtectionOrder();
        List<Integer> sigEncrActions = this.getSigEncrActions(results);
        if (sigEncrActions.size() < 2) {
            return;
        }
        boolean sigNotPresent = true;
        boolean encrNotPresent = true;
        for (Integer sigEncrAction : sigEncrActions) {
            Integer act = sigEncrAction;
            if (act == 2) {
                sigNotPresent = false;
                continue;
            }
            if (act != 4) continue;
            encrNotPresent = false;
        }
        if (sigNotPresent || encrNotPresent) {
            return;
        }
        boolean done = false;
        if ("SignBeforeEncrypting".equals(protectionOrder)) {
            Integer act;
            boolean sigFound = false;
            Iterator<Integer> iter = sigEncrActions.iterator();
            while (!(!iter.hasNext() && done || (act = iter.next()) == 4 && !sigFound)) {
                if (act == 2) {
                    sigFound = true;
                    continue;
                }
                if (!sigFound) continue;
                done = true;
            }
        } else {
            Integer sigEncrAction;
            Integer act;
            boolean encrFound = false;
            Iterator<Integer> iterator = sigEncrActions.iterator();
            while (iterator.hasNext() && ((act = (sigEncrAction = iterator.next())) != 2 || encrFound)) {
                if (act == 4) {
                    encrFound = true;
                    continue;
                }
                if (!encrFound) continue;
                done = true;
            }
        }
        if (!done) {
            throw new RampartException("protectionOrderMismatch");
        }
    }

    protected List<Integer> getSigEncrActions(List<WSSecurityEngineResult> results) {
        ArrayList<Integer> sigEncrActions = new ArrayList<Integer>();
        for (WSSecurityEngineResult result : results) {
            Integer action = (Integer)result.get((Object)"action");
            if (2 != action && 4 != action) continue;
            sigEncrActions.add(action);
        }
        return sigEncrActions;
    }

    protected void validateEncryptedParts(ValidatorData data, List<WSEncryptionPart> encryptedParts, List<WSSecurityEngineResult> results) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        ArrayList encrRefs = this.getEncryptedReferences(results);
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Set namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)envelope, rpd.getDeclaredNamespaces());
        HashMap decryptedElements = new HashMap();
        for (Object encrRef : encrRefs) {
            WSDataRef dataRef = (WSDataRef)encrRef;
            if (dataRef == null || dataRef.getXpath() == null) continue;
            try {
                AXIOMXPath xp = new AXIOMXPath(dataRef.getXpath());
                for (Object namespaceObject : namespaces) {
                    OMNamespace tmpNs = (OMNamespace)namespaceObject;
                    xp.addNamespace(tmpNs.getPrefix(), tmpNs.getNamespaceURI());
                }
                for (Object o : xp.selectNodes((Object)envelope)) {
                    decryptedElements.put(o, dataRef.isContent());
                }
            }
            catch (JaxenException e) {
                throw new RampartException("An error occurred while searching for decrypted elements.", e);
            }
        }
        if (rpd.isEncryptBody() && !rpd.isEncryptBodyOptional() && !this.isRefIdPresent(encrRefs, data.getBodyEncrDataId())) {
            throw new RampartException("encryptedPartMissing", new String[]{data.getBodyEncrDataId()});
        }
        for (WSEncryptionPart encryptedPart : encryptedParts) {
            if (encryptedPart.getName().equals("Body")) continue;
            if ("Signature".equals(encryptedPart.getName()) && "http://www.w3.org/2000/09/xmldsig#".equals(encryptedPart.getNamespace()) || encryptedPart.getEncModifier().equals("Header")) {
                if (this.isRefIdPresent(encrRefs, new QName(encryptedPart.getNamespace(), encryptedPart.getName()))) continue;
                throw new RampartException("encryptedPartMissing", new String[]{encryptedPart.getNamespace() + ":" + encryptedPart.getName()});
            }
            String xpath = encryptedPart.getXpath();
            boolean found = false;
            try {
                AXIOMXPath xp = new AXIOMXPath(xpath);
                for (Object namespaceObject : namespaces) {
                    OMNamespace tmpNs = (OMNamespace)namespaceObject;
                    xp.addNamespace(tmpNs.getPrefix(), tmpNs.getNamespaceURI());
                }
                for (Object o : xp.selectNodes((Object)envelope)) {
                    Object result = decryptedElements.get(o);
                    if (result == null || !("Element".equals(encryptedPart.getEncModifier()) ^ (Boolean)result)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RampartException("encryptedPartMissing", new String[]{xpath});
            }
            catch (JaxenException e) {
                throw new RampartException("An error occurred while searching for decrypted elements.", e);
            }
        }
    }

    public void validateRequiredElements(ValidatorData data) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        for (String expression : rpd.getRequiredElements()) {
            if (RampartUtil.checkRequiredElements(envelope, rpd.getDeclaredNamespaces(), expression)) continue;
            throw new RampartException("requiredElementsMissing", new String[]{expression});
        }
    }

    protected void validateSignedPartsHeaders(ValidatorData data, List<WSEncryptionPart> signatureParts, List<WSSecurityEngineResult> results) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        Node envelope = rmd.getDocument().getFirstChild();
        WSSecurityEngineResult[] actionResults = PolicyBasedResultsValidator.fetchActionResults(results, 2);
        ArrayList<QName> actuallySigned = new ArrayList<QName>();
        if (actionResults != null) {
            for (WSSecurityEngineResult actionResult : actionResults) {
                List wsDataRefs = (List)actionResult.get((Object)"data-ref-uris");
                block1: for (Object objectDataReference : wsDataRefs) {
                    WSDataRef wsDataRef = (WSDataRef)objectDataReference;
                    Element protectedElement = wsDataRef.getProtectedElement();
                    if (protectedElement.getLocalName().equals("EncryptedHeader")) {
                        NodeList nodeList = protectedElement.getChildNodes();
                        for (int x = 0; x < nodeList.getLength(); ++x) {
                            if (nodeList.item(x).getNodeType() != 1) continue;
                            String ns = nodeList.item(x).getNamespaceURI();
                            String ln = nodeList.item(x).getLocalName();
                            actuallySigned.add(new QName(ns, ln));
                            continue block1;
                        }
                        continue;
                    }
                    String ns = protectedElement.getNamespaceURI();
                    String ln = protectedElement.getLocalName();
                    actuallySigned.add(new QName(ns, ln));
                }
            }
        }
        for (WSEncryptionPart wsep : signatureParts) {
            Element element;
            if (wsep.getName().equals("Body")) {
                QName bodyQName = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getNamespaceURI()) ? new SOAP11Constants().getBodyQName() : new SOAP12Constants().getBodyQName();
                if (actuallySigned.contains(bodyQName) || rmd.getPolicyData().isSignBodyOptional()) continue;
                throw new RampartException("bodyNotSigned");
            }
            if (!wsep.getName().equals("Header") && wsep.getXpath() == null || (element = XMLUtils.findElement((Node)envelope, (String)wsep.getName(), (String)wsep.getNamespace())) == null || actuallySigned.contains(new QName(element.getNamespaceURI(), element.getLocalName()))) continue;
            String msg = wsep.getXpath() != null ? "signedPartHeaderNotSigned" : "signedElementNotSigned";
            throw new RampartException(msg, new String[]{wsep.getNamespace() + ":" + wsep.getName()});
        }
    }

    protected boolean isSignatureRequired(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        return rpd.isSymmetricBinding() && rpd.getSignatureToken() != null || !rpd.isSymmetricBinding() && !rpd.isTransportBinding() && (rpd.getInitiatorToken() != null && rmd.isInitiator() || rpd.getRecipientToken() != null && !rmd.isInitiator());
    }

    protected boolean verifyTimestamp(Timestamp timestamp, RampartMessageData rmd) throws RampartException {
        Instant expires;
        long maxSkew = RampartUtil.getTimestampMaxSkew(rmd);
        Instant createdTime = timestamp.getCreated();
        if (createdTime != null) {
            long now = Instant.now().toEpochMilli();
            if (maxSkew > 0L) {
                now += maxSkew * 1000L;
            }
            if (createdTime.toEpochMilli() > now) {
                return false;
            }
        }
        if ((expires = timestamp.getExpires()) != null) {
            long now = Instant.now().toEpochMilli();
            if (maxSkew > 0L) {
                now -= maxSkew * 1000L;
            }
            if (expires.toEpochMilli() < now) {
                return false;
            }
        }
        return true;
    }

    protected boolean verifyTrust(X509Certificate cert, RampartMessageData rmd) throws RampartException {
        if (cert == null) {
            return false;
        }
        Crypto crypto = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader());
        return this.isCertificateTrusted(cert, crypto);
    }

    protected boolean isCertificateTrusted(X509Certificate cert, Crypto crypto) throws RampartException {
        String subjectString = cert.getSubjectX500Principal().getName();
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transmitted certificate has subject " + subjectString));
            log.debug((Object)("Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        if (this.isCertificateInKeyStore(crypto, cert)) {
            return true;
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
        cryptoType.setSubjectDN(issuerString);
        X509Certificate[] foundCerts = new X509Certificate[]{};
        try {
            foundCerts = crypto.getX509Certificates(cryptoType);
        }
        catch (WSSecurityException e) {
            throw new RampartException("noCertForSubject", e);
        }
        if (foundCerts == null || foundCerts.length < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No certs found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Preparing to validate certificate path for issuer " + issuerString));
        }
        X509Certificate[] x509certs = new X509Certificate[foundCerts.length + 1];
        x509certs[0] = cert;
        for (int j = 0; j < foundCerts.length; ++j) {
            x509certs[j + 1] = foundCerts[j];
        }
        try {
            crypto.verifyTrust(x509certs, false, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate path has been verified for certificate with subject " + subjectString));
            }
            return true;
        }
        catch (WSSecurityException e) {
            log.error((Object)("Certificate path could not be verified for certificate with subject " + subjectString));
            throw new RampartException("certPathVerificationFailed", e);
        }
    }

    protected boolean isCertificateInKeyStore(Crypto crypto, X509Certificate cert) throws RampartException {
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerString, issuerSerial);
        X509Certificate[] foundCerts = new X509Certificate[]{};
        try {
            foundCerts = crypto.getX509Certificates(cryptoType);
        }
        catch (WSSecurityException e) {
            throw new RampartException("noCertificatesForIssuer", new String[]{issuerString, issuerSerial.toString()}, e);
        }
        if (foundCerts != null && foundCerts[0] != null && foundCerts[0].equals(cert)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Direct trust for certificate with " + cert.getSubjectX500Principal().getName()));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No certificate found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        return false;
    }

    protected ArrayList getEncryptedReferences(List<WSSecurityEngineResult> results) {
        List<WSSecurityEngineResult> encrResults = this.getResults(results, 4);
        ArrayList<WSDataRef> refs = new ArrayList<WSDataRef>();
        for (WSSecurityEngineResult engineResult : encrResults) {
            List dataRefUris = (List)engineResult.get((Object)"data-ref-uris");
            if (dataRefUris == null) continue;
            for (WSDataRef uri : dataRefUris) {
                refs.add(uri);
            }
        }
        return refs;
    }

    protected List<WSSecurityEngineResult> getResults(List<WSSecurityEngineResult> results, int action) {
        ArrayList<WSSecurityEngineResult> list = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != action) continue;
            list.add(result);
        }
        return list;
    }

    protected boolean isUsernameTokenPresent(ValidatorData data) {
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
        for (SupportingToken suppTok : supportingToks) {
            if (!this.isUsernameTokenPresent(suppTok)) continue;
            return true;
        }
        SupportingToken signedSuppToken = rpd.getSignedSupportingTokens();
        if (this.isUsernameTokenPresent(signedSuppToken)) {
            return true;
        }
        SupportingToken signedEndSuppToken = rpd.getSignedEndorsingSupportingTokens();
        if (this.isUsernameTokenPresent(signedEndSuppToken)) {
            return true;
        }
        SupportingToken endSuppToken = rpd.getEndorsingSupportingTokens();
        return this.isUsernameTokenPresent(endSuppToken);
    }

    protected boolean isUsernameTokenPresent(SupportingToken suppTok) {
        if (suppTok == null) {
            return false;
        }
        ArrayList tokens = suppTok.getTokens();
        for (Token token : tokens) {
            if (!(token instanceof UsernameToken)) continue;
            return true;
        }
        return false;
    }

    private boolean isRefIdPresent(ArrayList refList, String id) {
        if (id != null && id.charAt(0) == '#') {
            id = id.substring(1);
        }
        for (Object aRefList : refList) {
            String dataRefUri;
            WSDataRef dataRef = (WSDataRef)aRefList;
            if (dataRef == null || (dataRefUri = dataRef.getWsuId()) == null || !dataRefUri.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static WSSecurityEngineResult[] fetchActionResults(List<WSSecurityEngineResult> wsSecurityEngineResults, int action) {
        ArrayList<WSSecurityEngineResult> wsResult = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wsSecurityEngineResult : wsSecurityEngineResults) {
            WSSecurityEngineResult result = wsSecurityEngineResult;
            int resultAction = (Integer)result.get((Object)"action");
            if (resultAction != action) continue;
            wsResult.add(wsSecurityEngineResult);
        }
        return wsResult.toArray(new WSSecurityEngineResult[wsResult.size()]);
    }

    public static WSSecurityEngineResult fetchActionResult(List<WSSecurityEngineResult> resultList, int action) {
        WSSecurityEngineResult returnResult = null;
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get((Object)"action");
            if (resultAction != action) continue;
            returnResult = result;
        }
        return returnResult;
    }

    private boolean isRefIdPresent(ArrayList refList, QName qname) {
        for (Object aRefList : refList) {
            QName dataRefQName;
            WSDataRef dataRef = (WSDataRef)aRefList;
            if (dataRef == null || (dataRefQName = dataRef.getName()) == null || !dataRefQName.equals(qname)) continue;
            return true;
        }
        return false;
    }
}

