/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.tool;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openjdk.tools.internal.jshell.tool.IOContext;

public class ExternalEditor {
    private final Consumer<String> errorHandler;
    private final Consumer<String> saveHandler;
    private final IOContext input;
    private WatchService watcher;
    private Thread watchedThread;
    private Path dir;
    private Path tmpfile;

    ExternalEditor(Consumer<String> errorHandler, Consumer<String> saveHandler, IOContext input) {
        this.errorHandler = errorHandler;
        this.saveHandler = saveHandler;
        this.input = input;
    }

    private void edit(String[] cmd, String initialText) {
        try {
            this.setupWatch(initialText);
            this.launch(cmd);
        }
        catch (IOException ex) {
            this.errorHandler.accept(ex.getMessage());
        }
    }

    private void setupWatch(String initialText) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.dir = Files.createTempDirectory("REPL", new FileAttribute[0]);
        this.tmpfile = Files.createTempFile(this.dir, null, ".repl", new FileAttribute[0]);
        Files.write(this.tmpfile, initialText.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchedThread = new Thread(() -> {
            block5: {
                while (true) {
                    boolean valid;
                    WatchKey key;
                    try {
                        key = this.watcher.take();
                    }
                    catch (ClosedWatchServiceException ex) {
                        break block5;
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    if (!key.pollEvents().isEmpty() && !this.input.terminalEditorRunning()) {
                        this.saveFile();
                    }
                    if (!(valid = key.reset())) break;
                }
                this.errorHandler.accept("Invalid key");
            }
        });
        this.watchedThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launch(String[] cmd) throws IOException {
        String[] params = Arrays.copyOf(cmd, cmd.length + 1);
        params[cmd.length] = this.tmpfile.toString();
        ProcessBuilder pb = new ProcessBuilder(params);
        pb = pb.inheritIO();
        try {
            this.input.suspend();
            Process process = pb.start();
            process.waitFor();
            return;
        }
        catch (IOException ex) {
            this.errorHandler.accept("process IO failure: " + ex.getMessage());
            return;
        }
        catch (InterruptedException ex) {
            this.errorHandler.accept("process interrupt: " + ex.getMessage());
            return;
        }
        finally {
            try {
                this.watcher.close();
                this.watchedThread.join();
                this.saveFile();
            }
            catch (InterruptedException ex) {
                this.errorHandler.accept("process interrupt: " + ex.getMessage());
            }
            finally {
                this.input.resume();
            }
        }
    }

    private void saveFile() {
        try {
            this.saveHandler.accept(Files.lines(this.tmpfile).collect(Collectors.joining("\n", "", "\n")));
        }
        catch (IOException ex) {
            this.errorHandler.accept("Failure in read edit file: " + ex.getMessage());
        }
    }

    static void edit(String[] cmd, Consumer<String> errorHandler, String initialText, Consumer<String> saveHandler, IOContext input) {
        ExternalEditor ed = new ExternalEditor(errorHandler, saveHandler, input);
        ed.edit(cmd, initialText);
    }
}

