/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor9;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SearchIndexItem;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFile;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.IndexBuilder;

public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configuration, DocPath path, IndexBuilder indexbuilder) throws IOException {
        super(configuration, path);
        this.indexbuilder = indexbuilder;
    }

    @Override
    protected Content getNavLinkIndex() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.indexLabel);
        return li;
    }

    protected void addContents(Character uc, Collection<? extends Element> memberlist, Content contentTree) {
        this.addHeading(uc, contentTree);
        if (!memberlist.isEmpty()) {
            HtmlTree dl = new HtmlTree(HtmlTag.DL);
            for (Element element : memberlist) {
                this.addDescription(dl, element);
            }
            contentTree.addContent(dl);
        }
    }

    protected void addSearchContents(Character uc, List<SearchIndexItem> searchList, Content contentTree) {
        this.addHeading(uc, contentTree);
        if (!searchList.isEmpty()) {
            HtmlTree dl = new HtmlTree(HtmlTag.DL);
            for (SearchIndexItem sii : searchList) {
                this.addDescription(sii, dl);
            }
            contentTree.addContent(dl);
        }
    }

    protected void addContents(Character uc, List<? extends Element> memberlist, List<SearchIndexItem> searchList, Content contentTree) {
        this.addHeading(uc, contentTree);
        int memberListSize = memberlist.size();
        int searchListSize = searchList.size();
        int i = 0;
        int j = 0;
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        while (i < memberListSize && j < searchListSize) {
            String name = this.utils.getSimpleName(memberlist.get(i));
            if (name.compareTo(searchList.get(j).getLabel()) < 0) {
                this.addDescription(dl, memberlist.get(i));
                ++i;
                continue;
            }
            if (name.compareTo(searchList.get(j).getLabel()) > 0) {
                this.addDescription(searchList.get(j), dl);
                ++j;
                continue;
            }
            this.addDescription(dl, memberlist.get(i));
            this.addDescription(searchList.get(j), dl);
            ++j;
            ++i;
        }
        if (i >= memberListSize) {
            while (j < searchListSize) {
                this.addDescription(searchList.get(j), dl);
                ++j;
            }
        }
        if (j >= searchListSize) {
            while (i < memberListSize) {
                this.addDescription(dl, memberlist.get(i));
                ++i;
            }
        }
        contentTree.addContent(dl);
    }

    protected void addHeading(Character uc, Content contentTree) {
        String unicode = uc.toString();
        contentTree.addContent(this.getMarkerAnchorForIndex(unicode));
        StringContent headContent = new StringContent(unicode);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, false, HtmlStyle.title, headContent);
        contentTree.addContent(heading);
    }

    protected void addDescription(final Content dl, Element element) {
        final SearchIndexItem si = new SearchIndexItem();
        new SimpleElementVisitor9<Void, Void>(){

            @Override
            public Void visitPackage(PackageElement e, Void p) {
                AbstractIndexWriter.this.addDescription(e, dl, si);
                AbstractIndexWriter.this.configuration.packageSearchIndex.add(si);
                return null;
            }

            @Override
            public Void visitType(TypeElement e, Void p) {
                AbstractIndexWriter.this.addDescription(e, dl, si);
                AbstractIndexWriter.this.configuration.typeSearchIndex.add(si);
                return null;
            }

            @Override
            protected Void defaultAction(Element e, Void p) {
                AbstractIndexWriter.this.addDescription(e, dl, si);
                AbstractIndexWriter.this.configuration.memberSearchIndex.add(si);
                return null;
            }
        }.visit(element);
    }

    protected void addDescription(PackageElement pkg, Content dlTree, SearchIndexItem si) {
        Content link = this.getPackageLink(pkg, new StringContent(this.utils.getPackageName(pkg)));
        si.setLabel(this.utils.getPackageName(pkg));
        si.setCategory(this.getResource("doclet.Packages").toString());
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        ((Content)dt).addContent(this.getResource("doclet.package"));
        ((Content)dt).addContent(" " + this.utils.getPackageName(pkg));
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addSummaryComment(pkg, dd);
        dlTree.addContent(dd);
    }

    protected void addDescription(TypeElement typeElement, Content dlTree, SearchIndexItem si) {
        Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.INDEX, typeElement).strong(true));
        si.setContainingPackage(this.utils.getPackageName(this.utils.containingPackage(typeElement)));
        si.setLabel(this.utils.getSimpleName(typeElement));
        si.setCategory(this.getResource("doclet.Types").toString());
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        this.addClassInfo(typeElement, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment(typeElement, dd);
        dlTree.addContent(dd);
    }

    protected void addClassInfo(TypeElement te, Content contentTree) {
        contentTree.addContent(this.getResource("doclet.in", this.utils.getTypeElementName(te, false), this.getPackageLink(this.utils.containingPackage(te), this.utils.getPackageName(this.utils.containingPackage(te)))));
    }

    protected void addDescription(Element member, Content dlTree, SearchIndexItem si) {
        si.setContainingPackage(this.utils.getPackageName(this.utils.containingPackage(member)));
        si.setContainingClass(this.utils.getSimpleName(this.utils.getEnclosingTypeElement(member)));
        String name = this.utils.getSimpleName(member);
        if (this.utils.isExecutableElement(member)) {
            ExecutableElement ee = (ExecutableElement)member;
            name = name + this.utils.flatSignature(ee);
            si.setLabel(name);
            if (!this.utils.signature(ee).equals(this.utils.flatSignature(ee))) {
                si.setUrl(this.getName(this.getAnchor(ee)));
            }
        } else {
            si.setLabel(name);
        }
        si.setCategory(this.getResource("doclet.Members").toString());
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.getDocLink(LinkInfoImpl.Kind.INDEX, member, name));
        HtmlTree dt = HtmlTree.DT(span);
        ((Content)dt).addContent(" - ");
        this.addMemberDesc(member, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment(member, dd);
        dlTree.addContent(dd);
    }

    protected void addDescription(SearchIndexItem sii, Content dlTree) {
        String path = this.pathToRoot.isEmpty() ? "" : this.pathToRoot.getPath() + "/";
        path = path + sii.getUrl();
        HtmlTree labelLink = HtmlTree.A(path, new StringContent(sii.getLabel()));
        HtmlTree dt = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.searchTagLink, labelLink));
        ((Content)dt).addContent(" - ");
        ((Content)dt).addContent(this.getResource("doclet.Search_tag_in", sii.getHolder()));
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        if (sii.getDescription().isEmpty()) {
            ((Content)dd).addContent(this.getSpace());
        } else {
            ((Content)dd).addContent(sii.getDescription());
        }
        dlTree.addContent(dd);
    }

    protected void addComment(Element element, Content contentTree) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.block);
        if (this.utils.isDeprecated(element)) {
            div.addContent(span);
            List<? extends DocTree> tags = this.utils.getBlockTags(element, DocTree.Kind.DEPRECATED);
            if (!tags.isEmpty()) {
                this.addInlineDeprecatedComment(element, tags.get(0), div);
            }
            contentTree.addContent(div);
        } else {
            TypeElement encl = this.utils.getEnclosingTypeElement(element);
            while (encl != null) {
                if (this.utils.isDeprecated(encl)) {
                    div.addContent(span);
                    contentTree.addContent(div);
                    break;
                }
                encl = this.utils.getEnclosingTypeElement(encl);
            }
            this.addSummaryComment(element, contentTree);
        }
    }

    protected void addMemberDesc(Element member, Content contentTree) {
        TypeElement containing = this.utils.getEnclosingTypeElement(member);
        String classdesc = this.utils.getTypeElementName(containing, true) + " ";
        if (this.utils.isField(member)) {
            Content resource = this.getResource(this.utils.isStatic(member) ? "doclet.Static_variable_in" : "doclet.Variable_in", classdesc);
            contentTree.addContent(resource);
        } else if (this.utils.isConstructor(member)) {
            contentTree.addContent(this.getResource("doclet.Constructor_for", classdesc));
        } else if (this.utils.isMethod(member)) {
            Content resource = this.getResource(this.utils.isStatic(member) ? "doclet.Static_method_in" : "doclet.Method_in", classdesc);
            contentTree.addContent(resource);
        }
        this.addPreQualifiedClassLink(LinkInfoImpl.Kind.INDEX, containing, false, contentTree);
    }

    public Content getMarkerAnchorForIndex(String anchorNameForIndex) {
        return this.getMarkerAnchor(this.getNameForIndex(anchorNameForIndex), null);
    }

    public String getNameForIndex(String unicode) {
        return "I:" + this.getName(unicode);
    }

    protected void createSearchIndexFiles() {
        this.createSearchIndexFile(DocPaths.PACKAGE_SEARCH_INDEX_JSON, DocPaths.PACKAGE_SEARCH_INDEX_ZIP, this.configuration.packageSearchIndex);
        this.createSearchIndexFile(DocPaths.TYPE_SEARCH_INDEX_JSON, DocPaths.TYPE_SEARCH_INDEX_ZIP, this.configuration.typeSearchIndex);
        this.createSearchIndexFile(DocPaths.MEMBER_SEARCH_INDEX_JSON, DocPaths.MEMBER_SEARCH_INDEX_ZIP, this.configuration.memberSearchIndex);
        this.createSearchIndexFile(DocPaths.TAG_SEARCH_INDEX_JSON, DocPaths.TAG_SEARCH_INDEX_ZIP, this.configuration.tagSearchIndex);
    }

    protected void createSearchIndexFile(DocPath searchIndexFile, DocPath searchIndexZip, List<SearchIndexItem> searchIndex) {
        if (!searchIndex.isEmpty()) {
            try {
                StringBuilder searchVar = new StringBuilder("[");
                boolean first = true;
                DocFile searchFile = DocFile.createFileForOutput(this.configuration, searchIndexFile);
                Path p = Paths.get(searchFile.getPath(), new String[0]);
                for (SearchIndexItem item : searchIndex) {
                    if (first) {
                        searchVar.append(item.toString());
                        first = false;
                        continue;
                    }
                    searchVar.append(",").append(item.toString());
                }
                searchVar.append("]");
                Files.write(p, searchVar.toString().getBytes(), new OpenOption[0]);
                DocFile zipFile = DocFile.createFileForOutput(this.configuration, searchIndexZip);
                try (FileOutputStream fos = new FileOutputStream(zipFile.getPath());
                     ZipOutputStream zos = new ZipOutputStream(fos);){
                    this.zipFile(searchFile.getPath(), searchIndexFile, zos);
                }
                Files.delete(p);
            }
            catch (IOException ie) {
                throw new DocletAbortException(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(String inputFile, DocPath file, ZipOutputStream zos) {
        try {
            try {
                ZipEntry ze = new ZipEntry(file.getPath());
                zos.putNextEntry(ze);
                try (FileInputStream fis = new FileInputStream(new File(inputFile));){
                    byte[] buf = new byte[2048];
                    int len = fis.read(buf);
                    while (len > 0) {
                        zos.write(buf, 0, len);
                        len = fis.read(buf);
                    }
                }
            }
            finally {
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            throw new DocletAbortException(e);
        }
    }
}

