/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.MethodTypes;

public abstract class SubWriterHolderWriter
extends HtmlDocletWriter {
    protected HtmlTree mainTree = HtmlTree.MAIN();

    public SubWriterHolderWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public void addSummaryHeader(AbstractMemberWriter mw, TypeElement typeElement, Content memberTree) {
        mw.addSummaryAnchor(typeElement, memberTree);
        mw.addSummaryLabel(memberTree);
    }

    public Content getSummaryTableTree(AbstractMemberWriter mw, TypeElement typeElement, List<Content> tableContents, boolean showTabs) {
        Content caption;
        if (showTabs) {
            caption = this.getTableCaption(mw.methodTypes);
            this.generateMethodTypesScript(mw.typeMap, mw.methodTypes);
        } else {
            caption = this.getTableCaption(mw.getCaption());
        }
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.memberSummary, caption) : HtmlTree.TABLE(HtmlStyle.memberSummary, mw.getTableSummary(), caption);
        ((Content)table).addContent(this.getSummaryTableHeader(mw.getSummaryTableHeader(typeElement), "col"));
        for (Content tableContent : tableContents) {
            ((Content)table).addContent(tableContent);
        }
        return table;
    }

    public Content getTableCaption(Set<MethodTypes> methodTypes) {
        HtmlTree tabbedCaption = new HtmlTree(HtmlTag.CAPTION);
        for (MethodTypes type : methodTypes) {
            HtmlTree span;
            HtmlTree captionSpan;
            if (type.isDefaultTab()) {
                captionSpan = HtmlTree.SPAN(this.configuration.getResource(type.resourceKey()));
                span = HtmlTree.SPAN(type.tabId(), HtmlStyle.activeTableTab, captionSpan);
            } else {
                captionSpan = HtmlTree.SPAN(this.getMethodTypeLinks(type));
                span = HtmlTree.SPAN(type.tabId(), HtmlStyle.tableTab, captionSpan);
            }
            HtmlTree tabSpan = HtmlTree.SPAN(HtmlStyle.tabEnd, this.getSpace());
            ((Content)span).addContent(tabSpan);
            ((Content)tabbedCaption).addContent(span);
        }
        return tabbedCaption;
    }

    public Content getMethodTypeLinks(MethodTypes methodType) {
        String jsShow = "javascript:show(" + methodType.value() + ");";
        HtmlTree link = HtmlTree.A(jsShow, this.configuration.getResource(methodType.resourceKey()));
        return link;
    }

    public void addInheritedSummaryHeader(AbstractMemberWriter mw, TypeElement typeElement, Content inheritedTree) {
        mw.addInheritedSummaryAnchor(typeElement, inheritedTree);
        mw.addInheritedSummaryLabel(typeElement, inheritedTree);
    }

    protected void addIndexComment(Element member, Content contentTree) {
        List<? extends DocTree> tags = this.utils.getFirstSentenceTrees(member);
        this.addIndexComment(member, tags, contentTree);
    }

    protected void addIndexComment(Element member, List<? extends DocTree> firstSentenceTags, Content tdSummary) {
        List<? extends DocTree> deprs = this.utils.getBlockTags(member, DocTree.Kind.DEPRECATED);
        if (this.utils.isDeprecated(member)) {
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            ((Content)div).addContent(this.getSpace());
            if (!deprs.isEmpty()) {
                this.addInlineDeprecatedComment(member, deprs.get(0), div);
            }
            tdSummary.addContent(div);
            return;
        }
        Element te = member.getEnclosingElement();
        if (te != null && this.utils.isTypeElement(te) && this.utils.isDeprecated(te)) {
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            ((Content)div).addContent(this.getSpace());
            tdSummary.addContent(div);
        }
        this.addSummaryComment(member, firstSentenceTags, tdSummary);
    }

    public void addSummaryType(AbstractMemberWriter mw, Element member, Content tdSummaryType) {
        mw.addSummaryType(member, tdSummaryType);
    }

    public void addSummaryLinkComment(AbstractMemberWriter mw, Element member, Content contentTree) {
        List<? extends DocTree> tags = this.utils.getFirstSentenceTrees(member);
        this.addSummaryLinkComment(mw, member, tags, contentTree);
    }

    public void addSummaryLinkComment(AbstractMemberWriter mw, Element member, List<? extends DocTree> firstSentenceTags, Content tdSummary) {
        this.addIndexComment(member, firstSentenceTags, tdSummary);
    }

    public void addInheritedMemberSummary(AbstractMemberWriter mw, TypeElement typeElement, Element member, boolean isFirst, Content linksTree) {
        if (!isFirst) {
            linksTree.addContent(", ");
        }
        mw.addInheritedSummaryLink(typeElement, member, linksTree);
    }

    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    public void addClassContentTree(Content contentTree, Content classContentTree) {
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(classContentTree);
            contentTree.addContent(this.mainTree);
        } else {
            contentTree.addContent(classContentTree);
        }
    }

    public void addAnnotationContentTree(Content contentTree, Content annotationContentTree) {
        this.addClassContentTree(contentTree, annotationContentTree);
    }

    public Content getMemberTreeHeader() {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        return li;
    }

    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(this.getMemberTree(memberTree));
            memberSummaryTree.addContent(htmlTree);
        } else {
            memberSummaryTree.addContent(this.getMemberTree(memberTree));
        }
    }

    public Content getMemberTree(Content contentTree) {
        HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, contentTree);
        return ul;
    }

    public Content getMemberSummaryTree(Content contentTree) {
        return this.getMemberTree(HtmlStyle.summary, contentTree);
    }

    public Content getMemberDetailsTree(Content contentTree) {
        return this.getMemberTree(HtmlStyle.details, contentTree);
    }

    public Content getMemberTree(HtmlStyle style, Content contentTree) {
        HtmlTree div = HtmlTree.DIV(style, this.getMemberTree(contentTree));
        return div;
    }
}

