/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.DigestManager;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingReadOp;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerReader {
    private static final Logger logger = LoggerFactory.getLogger(LedgerReader.class);
    private final BookieClient bookieClient;

    public LedgerReader(BookKeeper bkc) {
        this.bookieClient = bkc.getBookieClient();
    }

    public static SortedMap<Long, ArrayList<BookieSocketAddress>> bookiesForLedger(LedgerHandle lh) {
        return lh.getLedgerMetadata().getEnsembles();
    }

    public void readEntriesFromAllBookies(final LedgerHandle lh, long eid, final BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<ByteBuf>>> callback) {
        List writeSet = lh.distributionSchedule.getWriteSet(eid);
        final AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        final HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = new BookkeeperInternalCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readEntryComplete(int rc, long lid, long eid, ByteBuf buffer, Object ctx) {
                ReadResult<Object> rr;
                BookieSocketAddress bookieAddress = (BookieSocketAddress)ctx;
                if (0 != rc) {
                    rr = new ReadResult<Object>(eid, rc, null, bookieAddress.getSocketAddress());
                } else {
                    try {
                        ByteBuf content = lh.macManager.verifyDigestAndReturnData(eid, buffer);
                        ByteBuf toRet = Unpooled.copiedBuffer((ByteBuf)content);
                        rr = new ReadResult<ByteBuf>(eid, 0, toRet, bookieAddress.getSocketAddress());
                    }
                    catch (BKException.BKDigestMatchException e) {
                        rr = new ReadResult<Object>(eid, -5, null, bookieAddress.getSocketAddress());
                    }
                    finally {
                        buffer.release();
                    }
                }
                readResults.add(rr);
                if (numBookies.decrementAndGet() == 0) {
                    callback.operationComplete(0, (Object)readResults);
                }
            }
        };
        ArrayList ensemble = lh.getLedgerMetadata().getEnsemble(eid);
        for (Integer idx : writeSet) {
            this.bookieClient.readEntry((BookieSocketAddress)ensemble.get(idx), lh.getId(), eid, readEntryCallback, ensemble.get(idx));
        }
    }

    public void forwardReadEntriesFromLastConfirmed(LedgerHandle lh, final BookkeeperInternalCallbacks.GenericCallback<List<LedgerEntry>> callback) {
        final ArrayList resultList = new ArrayList();
        AsyncCallback.ReadCallback readCallback = new AsyncCallback.ReadCallback(){

            public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> entries, Object ctx) {
                if (-13 == rc) {
                    callback.operationComplete(0, (Object)resultList);
                } else if (0 == rc) {
                    while (entries.hasMoreElements()) {
                        resultList.add(entries.nextElement());
                    }
                    long entryId = (Long)ctx;
                    PendingReadOp readOp = new PendingReadOp(lh, lh.bk.scheduler, ++entryId, entryId, (AsyncCallback.ReadCallback)this, (Object)entryId);
                    readOp.initiate();
                } else {
                    callback.operationComplete(rc, (Object)resultList);
                }
            }
        };
        ReadLastConfirmedOp.LastConfirmedDataCallback readLACCallback = (rc, recoveryData) -> {
            if (0 != rc) {
                callback.operationComplete(rc, (Object)resultList);
                return;
            }
            if (-1L >= recoveryData.lastAddConfirmed) {
                callback.operationComplete(0, (Object)resultList);
                return;
            }
            long entryId = recoveryData.lastAddConfirmed;
            PendingReadOp readOp = new PendingReadOp(lh, lh.bk.scheduler, entryId, entryId, readCallback, (Object)entryId);
            try {
                readOp.initiate();
            }
            catch (Throwable t) {
                logger.error("Failed to initialize pending read entry {} for ledger {} : ", new Object[]{entryId, lh.getLedgerMetadata(), t});
            }
        };
        new ReadLastConfirmedOp(lh, readLACCallback).initiate();
    }

    public void readLacs(LedgerHandle lh, long eid, BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<Long>>> callback) {
        List writeSet = lh.distributionSchedule.getWriteSet(eid);
        AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = (rc, lid, eid1, buffer, ctx) -> {
            ReadResult<Object> rr;
            InetSocketAddress bookieAddress = (InetSocketAddress)ctx;
            if (0 != rc) {
                rr = new ReadResult<Object>(eid1, rc, null, bookieAddress);
            } else {
                try {
                    DigestManager.RecoveryData data = lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                    rr = new ReadResult<Long>(eid1, 0, data.lastAddConfirmed, bookieAddress);
                }
                catch (BKException.BKDigestMatchException e) {
                    rr = new ReadResult<Object>(eid1, -5, null, bookieAddress);
                }
            }
            readResults.add(rr);
            if (numBookies.decrementAndGet() == 0) {
                callback.operationComplete(0, (Object)readResults);
            }
        };
        ArrayList ensemble = lh.getLedgerMetadata().getEnsemble(eid);
        for (Integer idx : writeSet) {
            this.bookieClient.readEntry((BookieSocketAddress)ensemble.get(idx), lh.getId(), eid, readEntryCallback, ensemble.get(idx));
        }
    }

    public static class ReadResult<T> {
        final long entryId;
        final int rc;
        final T value;
        final InetSocketAddress srcAddr;

        ReadResult(long entryId, int rc, T value, InetSocketAddress srcAddr) {
            this.entryId = entryId;
            this.rc = rc;
            this.value = value;
            this.srcAddr = srcAddr;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public int getResultCode() {
            return this.rc;
        }

        public T getValue() {
            return this.value;
        }

        public InetSocketAddress getBookieAddress() {
            return this.srcAddr;
        }
    }
}

