/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.collections.Pair;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.SlidingStats;
import com.twitter.common.util.Clock;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PipelineStats {
    private static final String FULL_PIPELINE_NAME = "full";
    private final Time precision;
    private final Clock clock;
    private final Map<String, SlidingStats> stages;

    public PipelineStats(String pipelineName, Set<String> stages, Time precision) {
        this(pipelineName, stages, Clock.SYSTEM_CLOCK, precision);
    }

    @VisibleForTesting
    PipelineStats(String pipelineName, Set<String> stages, Clock clock, Time precision) {
        MorePreconditions.checkNotBlank((String)pipelineName);
        MorePreconditions.checkNotBlank(stages);
        Preconditions.checkArgument((!stages.contains(FULL_PIPELINE_NAME) ? 1 : 0) != 0);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.precision = (Time)Preconditions.checkNotNull((Object)precision);
        this.stages = Maps.newHashMap();
        for (String stage : stages) {
            this.stages.put(stage, new SlidingStats(String.format("%s_%s", pipelineName, stage), precision.toString()));
        }
        this.stages.put(FULL_PIPELINE_NAME, new SlidingStats(String.format("%s_%s", pipelineName, FULL_PIPELINE_NAME), precision.toString()));
    }

    private void record(Snapshot snapshot) {
        for (Pair stage : snapshot.stages) {
            this.stages.get(stage.getFirst()).accumulate((Long)stage.getSecond());
        }
    }

    public Snapshot newSnapshot() {
        return new Snapshot(this);
    }

    @VisibleForTesting
    public SlidingStats getStatsForStage(String stage) {
        return this.stages.get(stage);
    }

    public class Snapshot {
        private final List<Pair<String, Long>> stages = Lists.newLinkedList();
        private final PipelineStats parent;
        private String currentStage;
        private long startTime;
        private long ticker;

        private Snapshot(PipelineStats parent) {
            this.parent = parent;
        }

        public void start(String stageName) {
            this.record((String)Preconditions.checkNotNull((Object)stageName));
        }

        private void record(String stageName) {
            long now = (Long)Amount.of((long)PipelineStats.this.clock.nowNanos(), (Unit)Time.NANOSECONDS).as((Unit)PipelineStats.this.precision);
            if (this.currentStage != null) {
                this.stages.add((Pair<String, Long>)Pair.of((Object)this.currentStage, (Object)(now - this.ticker)));
            } else {
                this.startTime = now;
            }
            if (stageName == null) {
                this.stages.add((Pair<String, Long>)Pair.of((Object)PipelineStats.FULL_PIPELINE_NAME, (Object)(now - this.startTime)));
            }
            this.ticker = now;
            this.currentStage = stageName;
        }

        public void end() {
            this.record(null);
            this.parent.record(this);
        }
    }
}

