/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.bookkeeper.proto.BookkeeperProtocol;

public interface BookieProtocol {
    public static final byte LOWEST_COMPAT_PROTOCOL_VERSION = 0;
    public static final byte CURRENT_PROTOCOL_VERSION = 2;
    public static final long INVALID_ENTRY_ID = -1L;
    public static final long LAST_ADD_CONFIRMED = -1L;
    public static final int MASTER_KEY_LENGTH = 20;
    public static final byte ADDENTRY = 1;
    public static final byte READENTRY = 2;
    public static final byte AUTH = 3;
    public static final byte READ_LAC = 4;
    public static final byte WRITE_LAC = 5;
    public static final byte GET_BOOKIE_INFO = 6;
    public static final int EOK = 0;
    public static final int ENOLEDGER = 1;
    public static final int ENOENTRY = 2;
    public static final int EBADREQ = 100;
    public static final int EIO = 101;
    public static final int EUA = 102;
    public static final int EBADVERSION = 103;
    public static final int EFENCED = 104;
    public static final int EREADONLY = 105;
    public static final short FLAG_NONE = 0;
    public static final short FLAG_DO_FENCING = 1;
    public static final short FLAG_RECOVERY_ADD = 2;

    public static class AuthResponse
    extends Response {
        final BookkeeperProtocol.AuthMessage authMessage;

        AuthResponse(byte protocolVersion, BookkeeperProtocol.AuthMessage authMessage) {
            super(protocolVersion, (byte)3, 0, -1L, -1L);
            this.authMessage = authMessage;
        }

        BookkeeperProtocol.AuthMessage getAuthMessage() {
            return this.authMessage;
        }
    }

    public static class ErrorResponse
    extends Response {
        ErrorResponse(byte protocolVersion, byte opCode, int errorCode, long ledgerId, long entryId) {
            super(protocolVersion, opCode, errorCode, ledgerId, entryId);
        }
    }

    public static class AddResponse
    extends Response {
        AddResponse(byte protocolVersion, int errorCode, long ledgerId, long entryId) {
            super(protocolVersion, (byte)1, errorCode, ledgerId, entryId);
        }
    }

    public static class ReadResponse
    extends Response {
        final ByteBuf data;

        ReadResponse(byte protocolVersion, int errorCode, long ledgerId, long entryId) {
            super(protocolVersion, (byte)2, errorCode, ledgerId, entryId);
            this.data = Unpooled.EMPTY_BUFFER;
        }

        ReadResponse(byte protocolVersion, int errorCode, long ledgerId, long entryId, ByteBuf data) {
            super(protocolVersion, (byte)2, errorCode, ledgerId, entryId);
            this.data = data;
        }

        boolean hasData() {
            return this.data != null;
        }

        ByteBuf getData() {
            return this.data;
        }
    }

    public static class Response {
        final byte protocolVersion;
        final byte opCode;
        final int errorCode;
        final long ledgerId;
        final long entryId;

        protected Response(byte protocolVersion, byte opCode, int errorCode, long ledgerId, long entryId) {
            this.protocolVersion = protocolVersion;
            this.opCode = opCode;
            this.errorCode = errorCode;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        byte getProtocolVersion() {
            return this.protocolVersion;
        }

        byte getOpCode() {
            return this.opCode;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        long getEntryId() {
            return this.entryId;
        }

        int getErrorCode() {
            return this.errorCode;
        }

        public String toString() {
            return String.format("Op(%d)[Ledger:%d,Entry:%d,errorCode=%d]", this.opCode, this.ledgerId, this.entryId, this.errorCode);
        }
    }

    public static class AuthRequest
    extends Request {
        final BookkeeperProtocol.AuthMessage authMessage;

        AuthRequest(byte protocolVersion, BookkeeperProtocol.AuthMessage authMessage) {
            super(protocolVersion, (byte)3, -1L, -1L, (short)0, null);
            this.authMessage = authMessage;
        }

        BookkeeperProtocol.AuthMessage getAuthMessage() {
            return this.authMessage;
        }
    }

    public static class ReadRequest
    extends Request {
        ReadRequest(byte protocolVersion, long ledgerId, long entryId, short flags) {
            super(protocolVersion, (byte)2, ledgerId, entryId, flags);
        }

        ReadRequest(byte protocolVersion, long ledgerId, long entryId, short flags, byte[] masterKey) {
            super(protocolVersion, (byte)2, ledgerId, entryId, flags, masterKey);
        }

        boolean isFencingRequest() {
            return (this.flags & 1) == 1;
        }
    }

    public static class AddRequest
    extends Request {
        final ByteBuf data;

        AddRequest(byte protocolVersion, long ledgerId, long entryId, short flags, byte[] masterKey, ByteBuf data) {
            super(protocolVersion, (byte)1, ledgerId, entryId, flags, masterKey);
            this.data = data.retain();
        }

        ByteBuf getData() {
            return this.data;
        }

        boolean isRecoveryAdd() {
            return (this.flags & 2) == 2;
        }

        void release() {
            this.data.release();
        }
    }

    public static class Request {
        final byte protocolVersion;
        final byte opCode;
        final long ledgerId;
        final long entryId;
        final short flags;
        final byte[] masterKey;

        protected Request(byte protocolVersion, byte opCode, long ledgerId, long entryId, short flags) {
            this(protocolVersion, opCode, ledgerId, entryId, flags, null);
        }

        protected Request(byte protocolVersion, byte opCode, long ledgerId, long entryId, short flags, byte[] masterKey) {
            this.protocolVersion = protocolVersion;
            this.opCode = opCode;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.flags = flags;
            this.masterKey = masterKey;
        }

        byte getProtocolVersion() {
            return this.protocolVersion;
        }

        byte getOpCode() {
            return this.opCode;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        long getEntryId() {
            return this.entryId;
        }

        short getFlags() {
            return this.flags;
        }

        boolean hasMasterKey() {
            return this.masterKey != null;
        }

        byte[] getMasterKey() {
            assert (this.hasMasterKey());
            return this.masterKey;
        }

        public String toString() {
            return String.format("Op(%d)[Ledger:%d,Entry:%d]", this.opCode, this.ledgerId, this.entryId);
        }
    }

    public static final class PacketHeader {
        public static int toInt(byte version, byte opCode, short flags) {
            if (version == 0) {
                return opCode;
            }
            return (version & 0xFF) << 24 | (opCode & 0xFF) << 16 | flags & 0xFFFF;
        }

        public static byte getVersion(int packetHeader) {
            return (byte)(packetHeader >> 24);
        }

        public static byte getOpCode(int packetHeader) {
            byte version = PacketHeader.getVersion(packetHeader);
            if (version == 0) {
                return (byte)packetHeader;
            }
            return (byte)(packetHeader >> 16 & 0xFF);
        }

        public static short getFlags(int packetHeader) {
            byte version = (byte)(packetHeader >> 24);
            if (version == 0) {
                return 0;
            }
            return (short)(packetHeader & 0xFFFF);
        }
    }
}

