/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.base.ExceptionalSupplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.BackoffStrategy;
import com.twitter.common.util.Clock;
import com.twitter.common.util.TruncatedBinaryBackoff;
import java.util.logging.Logger;

public class BackoffHelper {
    private static final Logger LOG = Logger.getLogger(BackoffHelper.class.getName());
    private static final Amount<Long, Time> DEFAULT_INITIAL_BACKOFF = Amount.of((long)1L, (Unit)Time.SECONDS);
    private static final Amount<Long, Time> DEFAULT_MAX_BACKOFF = Amount.of((long)1L, (Unit)Time.MINUTES);
    private final Clock clock;
    private final BackoffStrategy backoffStrategy;

    public BackoffHelper() {
        this(DEFAULT_INITIAL_BACKOFF, DEFAULT_MAX_BACKOFF);
    }

    public BackoffHelper(Amount<Long, Time> initialBackoff, Amount<Long, Time> maxBackoff) {
        this(new TruncatedBinaryBackoff(initialBackoff, maxBackoff));
    }

    public BackoffHelper(Amount<Long, Time> initialBackoff, Amount<Long, Time> maxBackoff, boolean stopAtMax) {
        this(new TruncatedBinaryBackoff(initialBackoff, maxBackoff, stopAtMax));
    }

    public BackoffHelper(BackoffStrategy backoffStrategy) {
        this(Clock.SYSTEM_CLOCK, backoffStrategy);
    }

    @VisibleForTesting
    BackoffHelper(Clock clock, BackoffStrategy backoffStrategy) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.backoffStrategy = (BackoffStrategy)Preconditions.checkNotNull((Object)backoffStrategy);
    }

    public <E extends Exception> void doUntilSuccess(final ExceptionalSupplier<Boolean, E> task) throws InterruptedException, BackoffStoppedException, E {
        this.doUntilResult(new ExceptionalSupplier<Boolean, E>(){

            public Boolean get() throws Exception {
                Boolean result = (Boolean)task.get();
                return Boolean.TRUE.equals(result) ? result : null;
            }
        });
    }

    public <T, E extends Exception> T doUntilResult(ExceptionalSupplier<T, E> task) throws InterruptedException, BackoffStoppedException, E {
        Object result = task.get();
        return (T)(result != null ? result : this.retryWork(task));
    }

    private <T, E extends Exception> T retryWork(ExceptionalSupplier<T, E> work) throws E, InterruptedException, BackoffStoppedException {
        long currentBackoffMs = 0L;
        while (this.backoffStrategy.shouldContinue(currentBackoffMs)) {
            currentBackoffMs = this.backoffStrategy.calculateBackoffMs(currentBackoffMs);
            LOG.fine("Operation failed, backing off for " + currentBackoffMs + "ms");
            this.clock.waitFor(currentBackoffMs);
            Object result = work.get();
            if (result == null) continue;
            return (T)result;
        }
        throw new BackoffStoppedException(String.format("Backoff stopped without succeeding.", new Object[0]));
    }

    public static class BackoffStoppedException
    extends RuntimeException {
        public BackoffStoppedException(String msg) {
            super(msg);
        }
    }
}

