/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.streamset;

import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.service.streamset.CacheableStreamPartitionConverter;
import org.apache.distributedlog.service.streamset.Partition;

public class DelimiterStreamPartitionConverter
extends CacheableStreamPartitionConverter {
    private final String delimiter;

    public DelimiterStreamPartitionConverter() {
        this("_");
    }

    public DelimiterStreamPartitionConverter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    protected Partition newPartition(String streamName) {
        String[] parts = StringUtils.split((String)streamName, (String)this.delimiter);
        if (null != parts && parts.length == 2) {
            try {
                int partition = Integer.parseInt(parts[1]);
                return new Partition(parts[0], partition);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Partition(streamName, 0);
    }
}

