/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.AlertStatsLogger;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.distributedlog.BKTransmitPacket;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.EntryBuffer;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.WriteLimiter;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.stats.OpStatsListener;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.common.util.Sizable;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.FlushException;
import org.apache.distributedlog.exceptions.InvalidEnvelopedEntryException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.TransactionIdOutOfOrderException;
import org.apache.distributedlog.exceptions.WriteCancelledException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.feature.CoreFeatureKeys;
import org.apache.distributedlog.injector.FailureInjector;
import org.apache.distributedlog.injector.RandomDelayFailureInjector;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;
import org.apache.distributedlog.lock.DistributedLock;
import org.apache.distributedlog.logsegment.LogSegmentEntryWriter;
import org.apache.distributedlog.logsegment.LogSegmentWriter;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.OrderedScheduler;
import org.apache.distributedlog.util.SimplePermitLimiter;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BKLogSegmentWriter
implements LogSegmentWriter,
AsyncCallback.AddCallback,
Runnable,
Sizable {
    static final Logger LOG = LoggerFactory.getLogger(BKLogSegmentWriter.class);
    private final String fullyQualifiedLogSegment;
    private final String streamName;
    private final int logSegmentMetadataVersion;
    private BKTransmitPacket packetPrevious;
    private Entry.Writer recordSetWriter;
    private final AtomicInteger outstandingTransmits;
    private final int transmissionThreshold;
    protected final LogSegmentEntryWriter entryWriter;
    private final CompressionCodec.Type compressionType;
    private final ReentrantLock transmitLock = new ReentrantLock();
    private final AtomicInteger transmitResult = new AtomicInteger(0);
    private final DistributedLock lock;
    private final boolean isDurableWriteEnabled;
    private DLSN lastDLSN = DLSN.InvalidDLSN;
    private final long startTxId;
    private long lastTxId = -999L;
    private long lastTxIdAcknowledged = -999L;
    private long outstandingBytes = 0L;
    private long numFlushesSinceRestart = 0L;
    private long numBytes = 0L;
    private long lastEntryId = Long.MIN_VALUE;
    private long lastTransmitNanos = Long.MIN_VALUE;
    private final int periodicKeepAliveMs;
    private volatile boolean controlFlushNeeded = false;
    private boolean immediateFlushEnabled = false;
    private int minDelayBetweenImmediateFlushMs = 0;
    private Stopwatch lastTransmit;
    private boolean streamEnded = false;
    private final ScheduledFuture<?> periodicFlushSchedule;
    private final ScheduledFuture<?> periodicKeepAliveSchedule;
    private final AtomicReference<ScheduledFuture<?>> transmitSchedFutureRef = new AtomicReference<Object>(null);
    private final AtomicReference<ScheduledFuture<?>> immFlushSchedFutureRef = new AtomicReference<Object>(null);
    private final AtomicReference<Exception> scheduledFlushException = new AtomicReference<Object>(null);
    private boolean enforceLock = true;
    private CompletableFuture<Void> closeFuture = null;
    private final boolean enableRecordCounts;
    private int positionWithinLogSegment = 0;
    private final long logSegmentSequenceNumber;
    private final DistributedLogConfiguration conf;
    private final OrderedScheduler scheduler;
    private final StatsLogger transmitOutstandingLogger;
    private final Counter transmitDataSuccesses;
    private final Counter transmitDataMisses;
    private final Gauge<Number> transmitOutstandingGauge;
    private final OpStatsLogger transmitDataPacketSize;
    private final Counter transmitControlSuccesses;
    private final Counter pFlushSuccesses;
    private final Counter pFlushMisses;
    private final OpStatsLogger writeTime;
    private final OpStatsLogger addCompleteTime;
    private final OpStatsLogger addCompleteQueuedTime;
    private final OpStatsLogger addCompleteDeferredTime;
    private final Counter pendingWrites;
    private final Function<Integer, CompletableFuture<Long>> GET_LAST_TXID_ACKNOWLEDGED_AFTER_TRANSMIT_FUNC = transmitRc -> {
        if (0 == transmitRc) {
            return FutureUtils.value((Object)this.getLastTxIdAcknowledged());
        }
        return FutureUtils.exception((Throwable)new BKTransmitException("Failed to transmit entry", transmitRc.intValue()));
    };
    final Function<Long, CompletableFuture<Long>> COMMIT_AFTER_FLUSH_FUNC = lastAckedTxId -> this.commit();
    private final AlertStatsLogger alertStatsLogger;
    private final WriteLimiter writeLimiter;
    private final FailureInjector writeDelayInjector;

    protected BKLogSegmentWriter(String streamName, String logSegmentName, DistributedLogConfiguration conf, int logSegmentMetadataVersion, LogSegmentEntryWriter entryWriter, DistributedLock lock, long startTxId, long logSegmentSequenceNumber, OrderedScheduler scheduler, StatsLogger statsLogger, StatsLogger perLogStatsLogger, AlertStatsLogger alertStatsLogger, PermitLimiter globalWriteLimiter, FeatureProvider featureProvider, DynamicDistributedLogConfiguration dynConf) throws IOException {
        PermitLimiter streamWriteLimiter = null;
        if (conf.getPerWriterOutstandingWriteLimit() < 0) {
            streamWriteLimiter = PermitLimiter.NULL_PERMIT_LIMITER;
        } else {
            Feature disableWriteLimitFeature = featureProvider.getFeature(CoreFeatureKeys.DISABLE_WRITE_LIMIT.name().toLowerCase());
            streamWriteLimiter = new SimplePermitLimiter(conf.getOutstandingWriteLimitDarkmode(), conf.getPerWriterOutstandingWriteLimit(), statsLogger.scope("streamWriteLimiter"), false, disableWriteLimitFeature);
        }
        this.writeLimiter = new WriteLimiter(streamName, streamWriteLimiter, globalWriteLimiter);
        this.alertStatsLogger = alertStatsLogger;
        StatsLogger flushStatsLogger = statsLogger.scope("flush");
        StatsLogger pFlushStatsLogger = flushStatsLogger.scope("periodic");
        this.pFlushSuccesses = pFlushStatsLogger.getCounter("success");
        this.pFlushMisses = pFlushStatsLogger.getCounter("miss");
        StatsLogger transmitDataStatsLogger = statsLogger.scope("data");
        this.transmitDataSuccesses = transmitDataStatsLogger.getCounter("success");
        this.transmitDataMisses = transmitDataStatsLogger.getCounter("miss");
        StatsLogger transmitStatsLogger = statsLogger.scope("transmit");
        this.transmitDataPacketSize = transmitStatsLogger.getOpStatsLogger("packetsize");
        StatsLogger transmitControlStatsLogger = statsLogger.scope("control");
        this.transmitControlSuccesses = transmitControlStatsLogger.getCounter("success");
        StatsLogger segWriterStatsLogger = statsLogger.scope("seg_writer");
        this.writeTime = segWriterStatsLogger.getOpStatsLogger("write");
        this.addCompleteTime = segWriterStatsLogger.scope("add_complete").getOpStatsLogger("callback");
        this.addCompleteQueuedTime = segWriterStatsLogger.scope("add_complete").getOpStatsLogger("queued");
        this.addCompleteDeferredTime = segWriterStatsLogger.scope("add_complete").getOpStatsLogger("deferred");
        this.pendingWrites = segWriterStatsLogger.getCounter("pending");
        this.transmitOutstandingLogger = perLogStatsLogger.scope("transmit").scope("outstanding");
        this.transmitOutstandingGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return BKLogSegmentWriter.this.outstandingTransmits.get();
            }
        };
        this.transmitOutstandingLogger.registerGauge("requests", this.transmitOutstandingGauge);
        this.outstandingTransmits = new AtomicInteger(0);
        this.fullyQualifiedLogSegment = streamName + ":" + logSegmentName;
        this.streamName = streamName;
        this.logSegmentMetadataVersion = logSegmentMetadataVersion;
        this.entryWriter = entryWriter;
        this.lock = lock;
        this.lock.checkOwnershipAndReacquire();
        int configuredTransmissionThreshold = dynConf.getOutputBufferSize();
        if (configuredTransmissionThreshold > 1044480) {
            LOG.warn("Setting output buffer size {} greater than max transmission size {} for log segment {}", new Object[]{configuredTransmissionThreshold, 1044480, this.fullyQualifiedLogSegment});
            this.transmissionThreshold = 1044480;
        } else {
            this.transmissionThreshold = configuredTransmissionThreshold;
        }
        this.compressionType = CompressionUtils.stringToType((String)conf.getCompressionType());
        this.logSegmentSequenceNumber = logSegmentSequenceNumber;
        this.recordSetWriter = Entry.newEntry(streamName, Math.max(this.transmissionThreshold, 1024), this.envelopeBeforeTransmit(), this.compressionType);
        this.packetPrevious = null;
        this.startTxId = startTxId;
        this.lastTxId = startTxId;
        this.lastTxIdAcknowledged = startTxId;
        this.enableRecordCounts = conf.getEnableRecordCounts();
        this.immediateFlushEnabled = conf.getImmediateFlushEnabled();
        this.isDurableWriteEnabled = dynConf.isDurableWriteEnabled();
        this.scheduler = scheduler;
        this.writeDelayInjector = conf.getEIInjectWriteDelay() ? new RandomDelayFailureInjector(dynConf) : FailureInjector.NULL;
        int configuredPeriodicFlushFrequency = dynConf.getPeriodicFlushFrequencyMilliSeconds();
        if (!this.immediateFlushEnabled || 0 != this.transmissionThreshold) {
            int periodicFlushFrequency = configuredPeriodicFlushFrequency;
            this.periodicFlushSchedule = periodicFlushFrequency > 0 && scheduler != null ? scheduler.scheduleAtFixedRate((Runnable)this, (long)(periodicFlushFrequency / 2), (long)(periodicFlushFrequency / 2), TimeUnit.MILLISECONDS) : null;
        } else {
            this.minDelayBetweenImmediateFlushMs = conf.getMinDelayBetweenImmediateFlushMs();
            this.periodicFlushSchedule = null;
        }
        this.periodicKeepAliveMs = conf.getPeriodicKeepAliveMilliSeconds();
        this.periodicKeepAliveSchedule = this.periodicKeepAliveMs > 0 && scheduler != null ? scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BKLogSegmentWriter.this.keepAlive();
            }
        }, (long)this.periodicKeepAliveMs, (long)this.periodicKeepAliveMs, TimeUnit.MILLISECONDS) : null;
        this.conf = conf;
        assert (!this.immediateFlushEnabled || null != this.scheduler);
        this.lastTransmit = Stopwatch.createStarted();
    }

    String getFullyQualifiedLogSegment() {
        return this.fullyQualifiedLogSegment;
    }

    @VisibleForTesting
    DistributedLock getLock() {
        return this.lock;
    }

    @VisibleForTesting
    ScheduledExecutorService getFuturePool() {
        return this.scheduler.chooseExecutor((Object)this.streamName);
    }

    @VisibleForTesting
    void setTransmitResult(int rc) {
        this.transmitResult.set(rc);
    }

    @VisibleForTesting
    protected final LogSegmentEntryWriter getEntryWriter() {
        return this.entryWriter;
    }

    @Override
    public long getLogSegmentId() {
        return this.entryWriter.getLogSegmentId();
    }

    protected final long getLogSegmentSequenceNumber() {
        return this.logSegmentSequenceNumber;
    }

    protected final long getStartTxId() {
        return this.startTxId;
    }

    synchronized long getLastTxId() {
        return this.lastTxId;
    }

    synchronized long getLastTxIdAcknowledged() {
        return this.lastTxIdAcknowledged;
    }

    synchronized int getPositionWithinLogSegment() {
        return this.positionWithinLogSegment;
    }

    @VisibleForTesting
    long getLastEntryId() {
        return this.lastEntryId;
    }

    synchronized DLSN getLastDLSN() {
        return this.lastDLSN;
    }

    public long size() {
        return this.entryWriter.size();
    }

    private synchronized int getAverageTransmitSize() {
        if (this.numFlushesSinceRestart > 0L) {
            long ret = this.numBytes / this.numFlushesSinceRestart;
            if (ret < Integer.MIN_VALUE || ret > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(ret + " transmit size should never exceed max transmit size");
            }
            return (int)ret;
        }
        return 0;
    }

    private Entry.Writer newRecordSetWriter() {
        return Entry.newEntry(this.streamName, Math.max(this.transmissionThreshold, this.getAverageTransmitSize()), this.envelopeBeforeTransmit(), this.compressionType);
    }

    private boolean envelopeBeforeTransmit() {
        return LogSegmentMetadata.supportsEnvelopedEntries(this.logSegmentMetadataVersion);
    }

    public CompletableFuture<Void> asyncClose() {
        return this.closeInternal(false);
    }

    public CompletableFuture<Void> asyncAbort() {
        return this.closeInternal(true);
    }

    private synchronized void abortPacket(BKTransmitPacket packet) {
        long numRecords = 0L;
        if (null != packet) {
            EntryBuffer recordSet = packet.getRecordSet();
            numRecords = recordSet.getNumRecords();
            int rc = this.transmitResult.get();
            if (0 == rc) {
                rc = -15;
            }
            WriteCancelledException reason = new WriteCancelledException(this.streamName, (Throwable)Utils.transmitException(rc));
            recordSet.abortTransmit((Throwable)reason);
        }
        LOG.info("Stream {} aborted {} writes", (Object)this.fullyQualifiedLogSegment, (Object)numRecords);
    }

    private synchronized long getWritesPendingTransmit() {
        if (null != this.recordSetWriter) {
            return this.recordSetWriter.getNumRecords();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeInternal(boolean abort) {
        CompletableFuture<Void> closePromise;
        BKLogSegmentWriter bKLogSegmentWriter = this;
        synchronized (bKLogSegmentWriter) {
            if (null != this.closeFuture) {
                return this.closeFuture;
            }
            this.closeFuture = new CompletableFuture<Void>();
            closePromise = this.closeFuture;
        }
        AtomicReference<Object> throwExc = new AtomicReference<Object>(null);
        this.closeInternal(abort, throwExc, closePromise);
        return closePromise;
    }

    private void closeInternal(final boolean abort, final AtomicReference<Throwable> throwExc, final CompletableFuture<Void> closePromise) {
        this.transmitOutstandingLogger.unregisterGauge("requests", this.transmitOutstandingGauge);
        this.writeLimiter.close();
        if (null != this.periodicKeepAliveSchedule && !this.periodicKeepAliveSchedule.cancel(false)) {
            LOG.info("Periodic keepalive for log segment {} isn't cancelled.", (Object)this.getFullyQualifiedLogSegment());
        }
        if (null != this.periodicFlushSchedule && !this.periodicFlushSchedule.cancel(false)) {
            LOG.info("Periodic flush for log segment {} isn't cancelled.", (Object)this.getFullyQualifiedLogSegment());
        }
        if (!abort && !this.isLogSegmentInError()) {
            this.enforceLock = false;
            LOG.info("Flushing before closing log segment {}", (Object)this.getFullyQualifiedLogSegment());
            this.flushAndCommit().whenComplete((BiConsumer)new FutureEventListener<Long>(){

                public void onSuccess(Long value) {
                    BKLogSegmentWriter.this.abortTransmitPacketOnClose(abort, throwExc, closePromise);
                }

                public void onFailure(Throwable cause) {
                    throwExc.set(cause);
                    BKLogSegmentWriter.this.abortTransmitPacketOnClose(abort, throwExc, closePromise);
                }
            });
        } else {
            this.abortTransmitPacketOnClose(abort, throwExc, closePromise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortTransmitPacketOnClose(boolean abort, AtomicReference<Throwable> throwExc, CompletableFuture<Void> closePromise) {
        BKTransmitPacket packetCurrentSaved;
        BKTransmitPacket packetPreviousSaved;
        LOG.info("Closing BKPerStreamLogWriter (abort={}) for {} : lastDLSN = {} outstandingTransmits = {} writesPendingTransmit = {}", new Object[]{abort, this.fullyQualifiedLogSegment, this.getLastDLSN(), this.outstandingTransmits.get(), this.getWritesPendingTransmit()});
        BKLogSegmentWriter bKLogSegmentWriter = this;
        synchronized (bKLogSegmentWriter) {
            packetPreviousSaved = this.packetPrevious;
            packetCurrentSaved = new BKTransmitPacket(this.recordSetWriter);
            this.recordSetWriter = this.newRecordSetWriter();
        }
        if (null != packetPreviousSaved) {
            packetPreviousSaved.addTransmitCompleteListener(new FutureEventListener<Integer>(){

                public void onSuccess(Integer transmitResult) {
                    BKLogSegmentWriter.this.abortPacket(packetCurrentSaved);
                }

                public void onFailure(Throwable cause) {
                    LOG.error("Unexpected error on transmit completion ", cause);
                }
            });
        } else {
            this.abortPacket(packetCurrentSaved);
        }
        this.closeLedgerOnClose(abort, throwExc, closePromise);
    }

    private void closeLedgerOnClose(final boolean abort, final AtomicReference<Throwable> throwExc, final CompletableFuture<Void> closePromise) {
        if (null == throwExc.get() && !this.isLogSegmentInError()) {
            this.entryWriter.asyncClose(new AsyncCallback.CloseCallback(){

                public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                    if (0 != rc && -11 != rc && !abort) {
                        throwExc.set(new IOException("Failed to close ledger for " + BKLogSegmentWriter.this.fullyQualifiedLogSegment + " : " + BKException.getMessage((int)rc)));
                    }
                    BKLogSegmentWriter.this.completeClosePromise(abort, throwExc, closePromise);
                }
            }, null);
        } else {
            this.completeClosePromise(abort, throwExc, closePromise);
        }
    }

    private void completeClosePromise(boolean abort, AtomicReference<Throwable> throwExc, CompletableFuture<Void> closePromise) {
        if (!abort && null == throwExc.get() && this.shouldFailCompleteLogSegment()) {
            throwExc.set(new BKTransmitException("Closing an errored stream : ", this.transmitResult.get()));
        }
        if (null == throwExc.get()) {
            FutureUtils.complete(closePromise, null);
        } else {
            FutureUtils.completeExceptionally(closePromise, (Throwable)throwExc.get());
        }
    }

    @Override
    public synchronized void write(LogRecord record) throws IOException {
        this.writeUserRecord(record);
        this.flushIfNeeded();
    }

    @Override
    public synchronized CompletableFuture<DLSN> asyncWrite(LogRecord record) {
        return this.asyncWrite(record, true);
    }

    public synchronized CompletableFuture<DLSN> asyncWrite(LogRecord record, boolean flush) {
        CompletableFuture result;
        block8: {
            result = null;
            try {
                if (record.isControl()) {
                    try {
                        this.transmit();
                    }
                    catch (IOException ioe) {
                        return FutureUtils.exception((Throwable)new WriteCancelledException(this.fullyQualifiedLogSegment, (Throwable)ioe));
                    }
                    result = this.writeControlLogRecord(record);
                    this.transmit();
                    break block8;
                }
                result = this.writeUserRecord(record);
                if (!this.isDurableWriteEnabled) {
                    result = FutureUtils.value((Object)DLSN.InvalidDLSN);
                }
                if (flush) {
                    this.flushIfNeeded();
                }
            }
            catch (IOException ioe) {
                if (null != result) {
                    LOG.error("Overriding first result with flush failure {}", (Object)result);
                }
                result = FutureUtils.exception((Throwable)ioe);
                this.flushIfNeededNoThrow();
            }
        }
        return result;
    }

    private synchronized CompletableFuture<DLSN> writeUserRecord(LogRecord record) throws IOException {
        if (null != this.closeFuture) {
            throw new WriteException(this.fullyQualifiedLogSegment, BKException.getMessage((int)-11));
        }
        if (0 != this.transmitResult.get()) {
            throw new WriteException(this.fullyQualifiedLogSegment, BKException.getMessage((int)this.transmitResult.get()));
        }
        if (this.streamEnded) {
            throw new EndOfStreamException("Writing to a stream after it has been marked as completed");
        }
        if (record.getTransactionId() < 0L || record.getTransactionId() == Long.MAX_VALUE) {
            throw new TransactionIdOutOfOrderException(record.getTransactionId());
        }
        this.writeDelayInjector.inject();
        this.writeLimiter.acquire();
        this.pendingWrites.inc();
        CompletableFuture<DLSN> future = null;
        try {
            ++this.positionWithinLogSegment;
            int numRecords = 1;
            if (record.isRecordSet()) {
                numRecords = LogRecordSet.numRecords((LogRecord)record);
            }
            future = this.writeInternal(record);
            this.positionWithinLogSegment += numRecords - 1;
        }
        catch (IOException ex) {
            this.writeLimiter.release();
            this.pendingWrites.dec();
            --this.positionWithinLogSegment;
            throw ex;
        }
        return FutureUtils.ensure(future, () -> {
            this.pendingWrites.dec();
            this.writeLimiter.release();
        });
    }

    boolean isLogSegmentInError() {
        return this.transmitResult.get() != 0;
    }

    boolean shouldFailCompleteLogSegment() {
        return this.transmitResult.get() != 0 && this.transmitResult.get() != -11;
    }

    public synchronized CompletableFuture<DLSN> writeInternal(LogRecord record) throws LogRecordTooLongException, LockingException, BKTransmitException, WriteException, InvalidEnvelopedEntryException {
        int logRecordSize = record.getPersistentSize();
        if (logRecordSize > 1040384) {
            throw new LogRecordTooLongException(String.format("Log Record of size %d written when only %d is allowed", logRecordSize, 1040384));
        }
        if (this.recordSetWriter.getNumBytes() + logRecordSize > 1044480) {
            this.checkStateAndTransmit();
        }
        this.checkWriteLock();
        if (this.enableRecordCounts) {
            record.setPositionWithinLogSegment(this.positionWithinLogSegment);
        }
        CompletableFuture<DLSN> writePromise = new CompletableFuture<DLSN>();
        writePromise.whenComplete((BiConsumer)new OpStatsListener(this.writeTime));
        this.recordSetWriter.writeRecord(record, writePromise);
        if (record.getTransactionId() < this.lastTxId) {
            LOG.info("Log Segment {} TxId decreased Last: {} Record: {}", new Object[]{this.fullyQualifiedLogSegment, this.lastTxId, record.getTransactionId()});
        }
        if (!record.isControl()) {
            this.lastTxId = record.getTransactionId();
            this.outstandingBytes += (long)(20 + record.getPayload().length);
        }
        return writePromise;
    }

    private synchronized CompletableFuture<DLSN> writeControlLogRecord() throws BKTransmitException, WriteException, InvalidEnvelopedEntryException, LockingException, LogRecordTooLongException {
        LogRecord controlRec = new LogRecord(this.lastTxId, DistributedLogConstants.CONTROL_RECORD_CONTENT);
        controlRec.setControl();
        return this.writeControlLogRecord(controlRec);
    }

    private synchronized CompletableFuture<DLSN> writeControlLogRecord(LogRecord record) throws BKTransmitException, WriteException, InvalidEnvelopedEntryException, LockingException, LogRecordTooLongException {
        return this.writeInternal(record);
    }

    private synchronized void writeEndOfStreamMarker() throws IOException {
        LogRecord endOfStreamRec = new LogRecord(Long.MAX_VALUE, "endOfStream".getBytes(Charsets.UTF_8));
        endOfStreamRec.setEndOfStream();
        this.writeInternal(endOfStreamRec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Long> markEndOfStream() {
        BKLogSegmentWriter bKLogSegmentWriter = this;
        synchronized (bKLogSegmentWriter) {
            try {
                this.writeEndOfStreamMarker();
            }
            catch (IOException e) {
                return FutureUtils.exception((Throwable)e);
            }
            this.streamEnded = true;
        }
        return this.flushAndCommit();
    }

    public synchronized int writeBulk(List<LogRecord> records) throws IOException {
        int numRecords = 0;
        for (LogRecord r : records) {
            this.write(r);
            ++numRecords;
        }
        return numRecords;
    }

    private void checkStateBeforeTransmit() throws WriteException {
        try {
            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_TransmitBeforeAddEntry);
        }
        catch (IOException e) {
            throw new WriteException(this.streamName, "Fail transmit before adding entries");
        }
    }

    synchronized void checkStateAndTransmit() throws BKTransmitException, WriteException, InvalidEnvelopedEntryException, LockingException {
        this.checkStateBeforeTransmit();
        this.transmit();
    }

    @Override
    public synchronized CompletableFuture<Long> flush() {
        CompletableFuture<Integer> transmitFuture;
        try {
            this.checkStateBeforeTransmit();
        }
        catch (WriteException e) {
            return FutureUtils.exception((Throwable)e);
        }
        try {
            transmitFuture = this.transmit();
        }
        catch (BKTransmitException e) {
            return FutureUtils.exception((Throwable)e);
        }
        catch (LockingException e) {
            return FutureUtils.exception((Throwable)e);
        }
        catch (WriteException e) {
            return FutureUtils.exception((Throwable)e);
        }
        catch (InvalidEnvelopedEntryException e) {
            return FutureUtils.exception((Throwable)e);
        }
        if (null == transmitFuture) {
            if (null != this.packetPrevious) {
                transmitFuture = this.packetPrevious.getTransmitFuture();
            } else {
                return FutureUtils.value((Object)this.getLastTxIdAcknowledged());
            }
        }
        return transmitFuture.thenCompose(this.GET_LAST_TXID_ACKNOWLEDGED_AFTER_TRANSMIT_FUNC);
    }

    @Override
    public synchronized CompletableFuture<Long> commit() {
        CompletableFuture<Integer> transmitFuture;
        try {
            try {
                transmitFuture = this.transmit();
            }
            catch (IOException ioe) {
                return FutureUtils.exception((Throwable)ioe);
            }
            if (null == transmitFuture) {
                this.writeControlLogRecord();
                return this.flush();
            }
        }
        catch (IOException ioe) {
            return FutureUtils.exception((Throwable)ioe);
        }
        return transmitFuture.thenCompose(this.GET_LAST_TXID_ACKNOWLEDGED_AFTER_TRANSMIT_FUNC);
    }

    CompletableFuture<Long> flushAndCommit() {
        return this.flush().thenCompose(this.COMMIT_AFTER_FLUSH_FUNC);
    }

    void flushIfNeededNoThrow() {
        try {
            this.flushIfNeeded();
        }
        catch (IOException ioe) {
            LOG.error("Encountered exception while flushing log records to stream {}", (Object)this.fullyQualifiedLogSegment, (Object)ioe);
        }
    }

    void scheduleFlushWithDelayIfNeeded(final Callable<?> callable, final AtomicReference<ScheduledFuture<?>> scheduledFutureRef) {
        long delayMs = Math.max(0L, (long)this.minDelayBetweenImmediateFlushMs - this.lastTransmit.elapsed(TimeUnit.MILLISECONDS));
        ScheduledFuture<?> scheduledFuture = scheduledFutureRef.get();
        if (null == scheduledFuture || scheduledFuture.isDone()) {
            scheduledFutureRef.set(this.scheduler.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    6 var1_1 = this;
                    synchronized (var1_1) {
                        scheduledFutureRef.set(null);
                        try {
                            callable.call();
                            BKLogSegmentWriter.this.scheduledFlushException.set(null);
                        }
                        catch (Exception exc) {
                            BKLogSegmentWriter.this.scheduledFlushException.set(exc);
                            LOG.error("Delayed flush failed", (Throwable)exc);
                        }
                    }
                }
            }, delayMs, TimeUnit.MILLISECONDS));
        }
    }

    void flushIfNeeded() throws BKTransmitException, WriteException, InvalidEnvelopedEntryException, LockingException, FlushException {
        if (this.outstandingBytes > (long)this.transmissionThreshold) {
            if (0 == this.minDelayBetweenImmediateFlushMs) {
                this.checkStateAndTransmit();
            } else {
                this.scheduleFlushWithDelayIfNeeded(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        BKLogSegmentWriter.this.checkStateAndTransmit();
                        return null;
                    }
                }, this.transmitSchedFutureRef);
                if (this.scheduledFlushException.get() != null) {
                    throw new FlushException("Last flush encountered an error while writing data to the backend", this.getLastTxId(), this.getLastTxIdAcknowledged(), (Throwable)this.scheduledFlushException.get());
                }
            }
        }
    }

    private void checkWriteLock() throws LockingException {
        try {
            if (FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_WriteInternalLostLock)) {
                throw new LockingException("/failpoint/lockpath", "failpoint is simulating a lost lock" + this.getFullyQualifiedLogSegment());
            }
        }
        catch (IOException e) {
            throw new LockingException("/failpoint/lockpath", "failpoint is simulating a lost lock for " + this.getFullyQualifiedLogSegment());
        }
        if (this.enforceLock) {
            this.lock.checkOwnershipAndReacquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Integer> transmit() throws BKTransmitException, LockingException, WriteException, InvalidEnvelopedEntryException {
        this.transmitLock.lock();
        try {
            ByteBuf toSend;
            Entry.Writer recordSetToTransmit;
            BKLogSegmentWriter bKLogSegmentWriter = this;
            synchronized (bKLogSegmentWriter) {
                block20: {
                    this.checkWriteLock();
                    if (!this.transmitResult.compareAndSet(0, 0)) {
                        LOG.error("Log Segment {} Trying to write to an errored stream; Error is {}", (Object)this.fullyQualifiedLogSegment, (Object)BKException.getMessage((int)this.transmitResult.get()));
                        throw new BKTransmitException("Trying to write to an errored stream; Error code : (" + this.transmitResult.get() + ") " + BKException.getMessage((int)this.transmitResult.get()), this.transmitResult.get());
                    }
                    if (this.recordSetWriter.getNumRecords() != 0) break block20;
                    this.transmitDataMisses.inc();
                    CompletableFuture<Integer> completableFuture = null;
                    return completableFuture;
                }
                recordSetToTransmit = this.recordSetWriter;
                this.recordSetWriter = this.newRecordSetWriter();
                this.outstandingBytes = 0L;
                if (recordSetToTransmit.hasUserRecords()) {
                    this.numBytes += (long)recordSetToTransmit.getNumBytes();
                    ++this.numFlushesSinceRestart;
                }
            }
            try {
                toSend = recordSetToTransmit.getBuffer();
                FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_TransmitFailGetBuffer);
            }
            catch (IOException e) {
                if (e instanceof InvalidEnvelopedEntryException) {
                    this.alertStatsLogger.raise("Invalid enveloped entry for segment {} : ", new Object[]{this.fullyQualifiedLogSegment, e});
                }
                LOG.error("Exception while enveloping entries for segment: {}", (Object)new Object[]{this.fullyQualifiedLogSegment}, (Object)e);
                this.transmitResult.set(-12);
                if (e instanceof InvalidEnvelopedEntryException) {
                    this.alertStatsLogger.raise("Invalid enveloped entry for segment {} : ", new Object[]{this.fullyQualifiedLogSegment, e});
                    throw (InvalidEnvelopedEntryException)((Object)e);
                }
                throw new WriteException(this.streamName, "Envelope Error");
            }
            BKLogSegmentWriter bKLogSegmentWriter2 = this;
            synchronized (bKLogSegmentWriter2) {
                BKTransmitPacket packet;
                this.lastTransmitNanos = MathUtils.nowInNano();
                this.packetPrevious = packet = new BKTransmitPacket(recordSetToTransmit);
                this.entryWriter.asyncAddEntry(toSend, this, packet);
                if (recordSetToTransmit.hasUserRecords()) {
                    this.transmitDataSuccesses.inc();
                } else {
                    this.transmitControlSuccesses.inc();
                }
                this.lastTransmit.reset().start();
                this.outstandingTransmits.incrementAndGet();
                this.controlFlushNeeded = false;
                CompletableFuture<Integer> completableFuture = packet.getTransmitFuture();
                return completableFuture;
            }
        }
        finally {
            this.transmitLock.unlock();
        }
    }

    private synchronized boolean haveDataToTransmit() {
        if (!this.transmitResult.compareAndSet(0, 0)) {
            return false;
        }
        return this.recordSetWriter.getNumRecords() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(final int rc, LedgerHandle handle, final long entryId, Object ctx) {
        EntryBuffer recordSet;
        final AtomicReference<Integer> effectiveRC = new AtomicReference<Integer>(rc);
        try {
            if (FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_TransmitComplete)) {
                effectiveRC.set(-999);
            }
        }
        catch (Exception exc) {
            effectiveRC.set(-999);
        }
        if (entryId > -1L && this.lastEntryId >= entryId) {
            LOG.error("Log segment {} saw out of order entry {} lastEntryId {}", new Object[]{this.fullyQualifiedLogSegment, entryId, this.lastEntryId});
        }
        this.lastEntryId = entryId;
        assert (ctx instanceof BKTransmitPacket);
        final BKTransmitPacket transmitPacket = (BKTransmitPacket)ctx;
        this.addCompleteTime.registerSuccessfulEvent(TimeUnit.MICROSECONDS.convert(System.nanoTime() - transmitPacket.getTransmitTime(), TimeUnit.NANOSECONDS), TimeUnit.MICROSECONDS);
        if (0 == rc && (recordSet = transmitPacket.getRecordSet()).hasUserRecords()) {
            BKLogSegmentWriter bKLogSegmentWriter = this;
            synchronized (bKLogSegmentWriter) {
                this.lastTxIdAcknowledged = Math.max(this.lastTxIdAcknowledged, recordSet.getMaxTxId());
            }
        }
        if (null != this.scheduler) {
            final Stopwatch queuedTime = Stopwatch.createStarted();
            this.scheduler.submit((Object)this.streamName, (Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Stopwatch deferredTime = Stopwatch.createStarted();
                    BKLogSegmentWriter.this.addCompleteQueuedTime.registerSuccessfulEvent(queuedTime.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                    BKLogSegmentWriter.this.addCompleteDeferredProcessing(transmitPacket, entryId, (Integer)effectiveRC.get());
                    BKLogSegmentWriter.this.addCompleteDeferredTime.registerSuccessfulEvent(deferredTime.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MILLISECONDS);
                    return null;
                }

                public String toString() {
                    return String.format("AddComplete(Stream=%s, entryId=%d, rc=%d)", BKLogSegmentWriter.this.fullyQualifiedLogSegment, entryId, rc);
                }
            }).whenComplete((BiConsumer)new FutureEventListener<Void>(){

                public void onSuccess(Void done) {
                }

                public void onFailure(Throwable cause) {
                    LOG.error("addComplete processing failed for {} entry {} lastTxId {} rc {} with error", new Object[]{BKLogSegmentWriter.this.fullyQualifiedLogSegment, entryId, transmitPacket.getRecordSet().getMaxTxId(), rc, cause});
                }
            });
            transmitPacket.notifyTransmitComplete(effectiveRC.get());
            this.outstandingTransmits.getAndDecrement();
        } else {
            transmitPacket.notifyTransmitComplete(effectiveRC.get());
            this.outstandingTransmits.getAndDecrement();
            this.addCompleteDeferredProcessing(transmitPacket, entryId, effectiveRC.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompleteDeferredProcessing(BKTransmitPacket transmitPacket, long entryId, int rc) {
        boolean cancelPendingPromises = false;
        EntryBuffer recordSet = transmitPacket.getRecordSet();
        BKLogSegmentWriter bKLogSegmentWriter = this;
        synchronized (bKLogSegmentWriter) {
            if (this.transmitResult.compareAndSet(0, rc)) {
                cancelPendingPromises = 0 != rc;
            } else {
                LOG.warn("Log segment {} entryId {}: Tried to set transmit result to ({}) but is already ({})", new Object[]{this.fullyQualifiedLogSegment, entryId, rc, this.transmitResult.get()});
            }
            if (this.transmitResult.get() != 0) {
                if (recordSet.hasUserRecords()) {
                    this.transmitDataPacketSize.registerFailedEvent((long)recordSet.getNumBytes(), TimeUnit.MICROSECONDS);
                }
            } else if (recordSet.hasUserRecords()) {
                this.transmitDataPacketSize.registerSuccessfulEvent((long)recordSet.getNumBytes(), TimeUnit.MICROSECONDS);
                this.controlFlushNeeded = true;
                if (this.immediateFlushEnabled) {
                    if (0 == this.minDelayBetweenImmediateFlushMs) {
                        this.backgroundFlush(true);
                    } else {
                        this.scheduleFlushWithDelayIfNeeded(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                BKLogSegmentWriter.this.backgroundFlush(true);
                                return null;
                            }
                        }, this.immFlushSchedFutureRef);
                    }
                }
            }
            if (0 == this.transmitResult.get()) {
                DLSN lastDLSNInPacket = recordSet.finalizeTransmit(this.logSegmentSequenceNumber, entryId);
                if (recordSet.hasUserRecords() && null != lastDLSNInPacket && this.lastDLSN.compareTo(lastDLSNInPacket) < 0) {
                    this.lastDLSN = lastDLSNInPacket;
                }
            }
        }
        if (0 == this.transmitResult.get()) {
            recordSet.completeTransmit(this.logSegmentSequenceNumber, entryId);
        } else {
            recordSet.abortTransmit(Utils.transmitException(this.transmitResult.get()));
        }
        if (cancelPendingPromises) {
            BKTransmitPacket packetCurrentSaved;
            BKLogSegmentWriter bKLogSegmentWriter2 = this;
            synchronized (bKLogSegmentWriter2) {
                packetCurrentSaved = new BKTransmitPacket(this.recordSetWriter);
                this.recordSetWriter = this.newRecordSetWriter();
            }
            packetCurrentSaved.getRecordSet().abortTransmit((Throwable)new WriteCancelledException(this.streamName, (Throwable)Utils.transmitException(this.transmitResult.get())));
        }
    }

    @Override
    public synchronized void run() {
        this.backgroundFlush(false);
    }

    private synchronized void backgroundFlush(boolean controlFlushOnly) {
        if (null != this.closeFuture) {
            LOG.debug("Skip background flushing since log segment {} is closing.", (Object)this.getFullyQualifiedLogSegment());
            return;
        }
        try {
            boolean newData = this.haveDataToTransmit();
            if (this.controlFlushNeeded || !controlFlushOnly && newData) {
                if (!newData) {
                    this.writeControlLogRecord();
                }
                this.transmit();
                this.pFlushSuccesses.inc();
            } else {
                this.pFlushMisses.inc();
            }
        }
        catch (IOException exc) {
            LOG.error("Log Segment {}: Error encountered by the periodic flush", (Object)this.fullyQualifiedLogSegment, (Object)exc);
        }
    }

    private synchronized void keepAlive() {
        if (null != this.closeFuture) {
            LOG.debug("Skip sending keepAlive control record since log segment {} is closing.", (Object)this.getFullyQualifiedLogSegment());
            return;
        }
        if (MathUtils.elapsedMSec((long)this.lastTransmitNanos) < (long)this.periodicKeepAliveMs) {
            return;
        }
        LogRecord controlRec = new LogRecord(this.lastTxId, DistributedLogConstants.KEEPALIVE_RECORD_CONTENT);
        controlRec.setControl();
        this.asyncWrite(controlRec);
    }
}

