/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.logsegment;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.impl.logsegment.BKLogSegmentEntryWriter;
import org.apache.distributedlog.logsegment.LogSegmentEntryWriter;
import org.apache.distributedlog.util.Allocator;
import org.apache.distributedlog.util.Transaction;

class BKLogSegmentAllocator
implements Allocator<LogSegmentEntryWriter, Object> {
    LedgerAllocator allocator;

    BKLogSegmentAllocator(LedgerAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void allocate() throws IOException {
        this.allocator.allocate();
    }

    @Override
    public CompletableFuture<LogSegmentEntryWriter> tryObtain(Transaction<Object> txn, final Transaction.OpListener<LogSegmentEntryWriter> listener) {
        return this.allocator.tryObtain(txn, new Transaction.OpListener<LedgerHandle>(){

            @Override
            public void onCommit(LedgerHandle lh) {
                listener.onCommit(new BKLogSegmentEntryWriter(lh));
            }

            @Override
            public void onAbort(Throwable t) {
                listener.onAbort(t);
            }
        }).thenApply(NewLogSegmentEntryWriterFn.INSTANCE);
    }

    public CompletableFuture<Void> asyncClose() {
        return this.allocator.asyncClose();
    }

    public CompletableFuture<Void> delete() {
        return this.allocator.delete();
    }

    private static class NewLogSegmentEntryWriterFn
    implements Function<LedgerHandle, LogSegmentEntryWriter> {
        static final Function<LedgerHandle, LogSegmentEntryWriter> INSTANCE = new NewLogSegmentEntryWriterFn();

        private NewLogSegmentEntryWriterFn() {
        }

        @Override
        public LogSegmentEntryWriter apply(LedgerHandle lh) {
            return new BKLogSegmentEntryWriter(lh);
        }
    }
}

