/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.links.LinkFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.links.LinkInfo;

public class LinkFactoryImpl
extends LinkFactory {
    private final HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter writer) {
        this.m_writer = writer;
    }

    @Override
    protected Content newContent() {
        return new ContentBuilder();
    }

    @Override
    protected Content getClassLink(LinkInfo linkInfo) {
        ConfigurationImpl configuration = this.m_writer.configuration;
        Utils utils = configuration.utils;
        LinkInfoImpl classLinkInfo = (LinkInfoImpl)linkInfo;
        boolean noLabel = linkInfo.label == null || linkInfo.label.isEmpty();
        TypeElement typeElement = classLinkInfo.typeElement;
        String title = "";
        if (classLinkInfo.where == null || classLinkInfo.where.length() == 0) {
            boolean isTypeLink = classLinkInfo.type != null && utils.isTypeVariable(utils.getComponentType(classLinkInfo.type));
            title = this.getClassToolTip(typeElement, isTypeLink);
        }
        Content label = classLinkInfo.getClassLinkLabel(this.m_writer.configuration);
        ContentBuilder link = new ContentBuilder();
        if (utils.isIncluded(typeElement)) {
            if (configuration.isGeneratedDoc(typeElement)) {
                DocPath filename = this.getPath(classLinkInfo);
                if (linkInfo.linkToSelf || !DocPath.forName(utils, typeElement).equals(this.m_writer.filename)) {
                    ((Content)link).addContent(this.m_writer.getHyperLink(filename.fragment(classLinkInfo.where), label, classLinkInfo.isStrong, classLinkInfo.styleName, title, classLinkInfo.target));
                    if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                        ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
                    }
                    return link;
                }
            }
        } else {
            Content crossLink = this.m_writer.getCrossClassLink(typeElement.getQualifiedName().toString(), classLinkInfo.where, label, classLinkInfo.isStrong, classLinkInfo.styleName, true);
            if (crossLink != null) {
                ((Content)link).addContent(crossLink);
                if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                    ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
                }
                return link;
            }
        }
        ((Content)link).addContent(label);
        if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
            ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
        }
        return link;
    }

    @Override
    protected Content getTypeParameterLink(LinkInfo linkInfo, TypeMirror typeParam) {
        LinkInfoImpl typeLinkInfo = new LinkInfoImpl(this.m_writer.configuration, ((LinkInfoImpl)linkInfo).getContext(), typeParam);
        typeLinkInfo.excludeTypeBounds = linkInfo.excludeTypeBounds;
        typeLinkInfo.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        typeLinkInfo.linkToSelf = linkInfo.linkToSelf;
        typeLinkInfo.isJava5DeclarationLocation = false;
        return this.getLink(typeLinkInfo);
    }

    @Override
    protected Content getTypeAnnotationLink(LinkInfo linkInfo, AnnotationMirror annotation) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public Content getTypeAnnotationLinks(LinkInfo linkInfo) {
        List<? extends AnnotationMirror> annotations;
        Utils utils = ((LinkInfoImpl)linkInfo).utils;
        ContentBuilder links = new ContentBuilder();
        if (utils.isAnnotated(linkInfo.type)) {
            annotations = linkInfo.type.getAnnotationMirrors();
        } else if (utils.isTypeVariable(linkInfo.type)) {
            switch (((LinkInfoImpl)linkInfo).context) {
                case MEMBER_TYPE_PARAMS: 
                case EXECUTABLE_MEMBER_PARAM: 
                case CLASS_SIGNATURE: {
                    Element element = utils.typeUtils.asElement(linkInfo.type);
                    annotations = element.getAnnotationMirrors();
                    break;
                }
                default: {
                    annotations = linkInfo.type.getAnnotationMirrors();
                    break;
                }
            }
        } else {
            return links;
        }
        if (annotations.isEmpty()) {
            return links;
        }
        List<Content> annos = this.m_writer.getAnnotations(0, annotations, false, linkInfo.isJava5DeclarationLocation);
        boolean isFirst = true;
        for (Content anno : annos) {
            if (!isFirst) {
                links.addContent(" ");
            }
            links.addContent(anno);
            isFirst = false;
        }
        if (!annos.isEmpty()) {
            links.addContent(" ");
        }
        return links;
    }

    private String getClassToolTip(TypeElement typeElement, boolean isTypeLink) {
        ConfigurationImpl configuration = this.m_writer.configuration;
        Utils utils = configuration.utils;
        if (isTypeLink) {
            return configuration.getText("doclet.Href_Type_Param_Title", utils.getSimpleName(typeElement));
        }
        if (utils.isInterface(typeElement)) {
            return configuration.getText("doclet.Href_Interface_Title", utils.getPackageName(utils.containingPackage(typeElement)));
        }
        if (utils.isAnnotationType(typeElement)) {
            return configuration.getText("doclet.Href_Annotation_Title", utils.getPackageName(utils.containingPackage(typeElement)));
        }
        if (utils.isEnum(typeElement)) {
            return configuration.getText("doclet.Href_Enum_Title", utils.getPackageName(utils.containingPackage(typeElement)));
        }
        return configuration.getText("doclet.Href_Class_Title", utils.getPackageName(utils.containingPackage(typeElement)));
    }

    private DocPath getPath(LinkInfoImpl linkInfo) {
        if (linkInfo.context == LinkInfoImpl.Kind.PACKAGE_FRAME) {
            return DocPath.forName(linkInfo.utils, linkInfo.typeElement);
        }
        return this.m_writer.pathToRoot.resolve(DocPath.forClass(linkInfo.utils, linkInfo.typeElement));
    }
}

