/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html.markup;

import java.io.IOException;
import java.io.Writer;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;

public class StringContent
extends Content {
    private StringBuilder stringContent = new StringBuilder();

    public StringContent() {
    }

    public StringContent(CharSequence initialContent) {
        this.appendChars(initialContent);
    }

    @Override
    public void addContent(Content content) {
        throw new DocletAbortException("not supported");
    }

    @Override
    public void addContent(CharSequence strContent) {
        this.appendChars(strContent);
    }

    @Override
    public boolean isEmpty() {
        return this.stringContent.length() == 0;
    }

    @Override
    public int charCount() {
        return RawHtml.charCount(this.stringContent.toString());
    }

    @Override
    public String toString() {
        return this.stringContent.toString();
    }

    @Override
    public boolean write(Writer out, boolean atNewline) throws IOException {
        String s = this.stringContent.toString();
        out.write(s);
        return s.endsWith(DocletConstants.NL);
    }

    private void appendChars(CharSequence s) {
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    this.stringContent.append("&lt;");
                    continue block5;
                }
                case '>': {
                    this.stringContent.append("&gt;");
                    continue block5;
                }
                case '&': {
                    this.stringContent.append("&amp;");
                    continue block5;
                }
                default: {
                    this.stringContent.append(ch);
                }
            }
        }
    }
}

