/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class ImplementedMethods {
    private final Map<ExecutableElement, TypeMirror> interfaces = new HashMap<ExecutableElement, TypeMirror>();
    private final List<ExecutableElement> methlist = new ArrayList<ExecutableElement>();
    private final Utils utils;
    private final TypeElement typeElement;
    private final ExecutableElement method;

    public ImplementedMethods(ExecutableElement method, Configuration configuration) {
        this.method = method;
        this.utils = configuration.utils;
        this.typeElement = this.utils.getEnclosingTypeElement(method);
    }

    public List<ExecutableElement> build() {
        this.buildImplementedMethodList();
        return this.methlist;
    }

    public TypeMirror getMethodHolder(ExecutableElement ee) {
        return this.interfaces.get(ee);
    }

    private void buildImplementedMethodList() {
        Set<TypeMirror> intfacs = this.utils.getAllInterfaces(this.typeElement);
        for (TypeMirror interfaceType : intfacs) {
            ExecutableElement found = this.utils.findMethod(this.utils.asTypeElement(interfaceType), this.method);
            if (found == null) continue;
            this.removeOverriddenMethod(found);
            if (this.overridingMethodFound(found)) continue;
            this.methlist.add(found);
            this.interfaces.put(found, interfaceType);
        }
    }

    private void removeOverriddenMethod(ExecutableElement method) {
        TypeElement overriddenClass = this.utils.overriddenClass(method);
        if (overriddenClass != null) {
            for (int i = 0; i < this.methlist.size(); ++i) {
                TypeElement te = this.utils.getEnclosingTypeElement(this.methlist.get(i));
                if (te != overriddenClass && !this.utils.isSubclassOf(overriddenClass, te)) continue;
                this.methlist.remove(i);
                return;
            }
        }
    }

    private boolean overridingMethodFound(ExecutableElement method) {
        TypeElement containingClass = this.utils.getEnclosingTypeElement(method);
        for (ExecutableElement listmethod : this.methlist) {
            if (containingClass == this.utils.getEnclosingTypeElement(listmethod)) {
                return true;
            }
            TypeElement te = this.utils.overriddenClass(listmethod);
            if (te == null || te != containingClass && !this.utils.isSubclassOf(te, containingClass)) continue;
            return true;
        }
        return false;
    }
}

