/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.parsers.TypeParameterizedParser;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Unit;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmountParser
extends TypeParameterizedParser<Amount<?, ?>> {
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("(\\d+)([A-Za-z]+)");

    public AmountParser() {
        super(2);
    }

    @Override
    Amount<?, ?> doParse(ParserOracle parserOracle, String raw, List<Type> typeParams) {
        Type valueType = typeParams.get(0);
        Parser parser = parserOracle.get(TypeToken.of((Type)valueType));
        Matcher matcher = AMOUNT_PATTERN.matcher(raw);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Value '" + raw + "' must be of the format 1ns, 4mb, etc."));
        Number number = (Number)parser.parse(parserOracle, valueType, matcher.group(1));
        String unitRaw = matcher.group(2);
        Type unitType = typeParams.get(1);
        Parser unitParser = parserOracle.get(TypeToken.of(Unit.class));
        Unit unit = (Unit)unitParser.parse(parserOracle, unitType, unitRaw);
        Preconditions.checkArgument((unit.getClass() == unitType ? 1 : 0) != 0, (Object)String.format("Unit type (%s) does not match argument type (%s).", unit.getClass(), unitType));
        return AmountParser.create(valueType, number, unit);
    }

    private static Amount<?, ?> create(Type valueType, Number number, Unit unit) {
        if (valueType == Integer.class) {
            return Amount.of((int)number.intValue(), (Unit)unit);
        }
        if (valueType == Double.class) {
            return Amount.of((double)number.doubleValue(), (Unit)unit);
        }
        if (valueType == Long.class) {
            return Amount.of((long)number.longValue(), (Unit)unit);
        }
        if (valueType == Byte.class) {
            return Amount.of((int)number.byteValue(), (Unit)unit);
        }
        if (valueType == Short.class) {
            return Amount.of((int)number.shortValue(), (Unit)unit);
        }
        if (valueType == Float.class) {
            return Amount.of((float)number.floatValue(), (Unit)unit);
        }
        throw new IllegalArgumentException("Unrecognized number class " + valueType);
    }
}

