/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CounterMap<K>
implements Iterable<Map.Entry<K, Integer>>,
Cloneable {
    private final Map<K, Integer> map = Maps.newHashMap();
    private static Logger log = Logger.getLogger(CounterMap.class.getName());

    public int incrementAndGet(K k) {
        return this.incrementAndGet(k, 1);
    }

    public int incrementAndGet(K k, int n) {
        Integer n2 = this.map.get(k);
        if (n2 == null) {
            n2 = 0;
        }
        int n3 = n + n2;
        this.map.put(k, n3);
        return n3;
    }

    public int get(K k) {
        if (!this.map.containsKey(k)) {
            return 0;
        }
        return this.map.get(k);
    }

    public void set(K k, int n) {
        Preconditions.checkNotNull(k);
        this.map.put(k, n);
    }

    public void reset(K k) {
        this.map.remove(k);
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<Map.Entry<K, Integer>> iterator() {
        return this.map.entrySet().iterator();
    }

    public Collection<Integer> values() {
        return this.map.values();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<K, Integer> entry : this) {
            stringBuilder.append(entry.getKey().toString()).append(": ").append(entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public Map<K, Integer> toMap() {
        return this.map;
    }

    public CounterMap<K> clone() {
        CounterMap<K> counterMap = new CounterMap<K>();
        counterMap.map.putAll(this.map);
        return counterMap;
    }
}

