/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.jsr166e.LongAdder;
import com.twitter.util.WindowedAdder$;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00019<a!\u0001\u0002\t\u0002\u0011A\u0011!D,j]\u0012|w/\u001a3BI\u0012,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0004uo&$H/\u001a:\u000b\u0003\u001d\t1aY8n!\tI!\"D\u0001\u0003\r\u0019Y!\u0001#\u0001\u0005\u0019\tiq+\u001b8e_^,G-\u00113eKJ\u001c\"AC\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011\u0015!\"\u0002\"\u0001\u0017\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0005\t\u000baQA\u0011A\r\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\tiI7.\u001c\t\u0003\u0013m1Qa\u0003\u0002\u0001\tq\u0019\"aG\u0007\t\u0011yY\"\u0011!Q\u0001\n}\taa^5oI><\bC\u0001\b!\u0013\t\tsB\u0001\u0003M_:<\u0007\u0002C\u0012\u001c\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u00039\u0003\"AD\u0013\n\u0005\u0019z!aA%oi\"A\u0001f\u0007B\u0001B\u0003%\u0011&A\u0002o_^\u00042A\u0004\u0016 \u0013\tYsBA\u0005Gk:\u001cG/[8oa!1Ac\u0007C\u000175\"BA\u0007\u00180a!)a\u0004\fa\u0001?!)1\u0005\fa\u0001I!)\u0001\u0006\fa\u0001S!1!g\u0007Q\u0001\nM\naa\u001e:ji\u0016\u0014\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0005\u0003\u001dQ7O]\u00197m\u0015L!\u0001O\u001b\u0003\u00131{gnZ!eI\u0016\u0014\bB\u0002\u001e\u001cA\u0003&A%A\u0002hK:D#!\u000f\u001f\u0011\u00059i\u0014B\u0001 \u0010\u0005!1x\u000e\\1uS2,\u0007B\u0002!\u001cA\u0003%\u0011)\u0001\u0006fqBL'/\u001a3HK:\u0004\"A\u0011&\u000e\u0003\rS!\u0001R#\u0002\r\u0005$x.\\5d\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0001%\u000b\u0003%\u000bAA[1wC&\u00111j\u0011\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\r5[\u0002\u0015!\u0003O\u0003\r\u0011WO\u001a\t\u0004\u001d={\u0012B\u0001)\u0010\u0005\u0015\t%O]1z\u0011\u0019\u00116\u0004)Q\u0005I\u0005\t\u0011\u000e\u000b\u0002Ry!1Qk\u0007Q!\n}\t1a\u001c7eQ\t!F\b\u0003\u0004Y7\u0001&I!W\u0001\bKb\u0004\u0018N]3e)\u0005Q\u0006C\u0001\b\\\u0013\tavB\u0001\u0003V]&$\b\"\u00020\u001c\t\u0003I\u0016!\u0002:fg\u0016$\b\"\u00021\u001c\t\u0003I\u0016\u0001B5oGJDQAY\u000e\u0005\u0002\r\f1!\u00193e)\tQF\rC\u0003fC\u0002\u0007A%A\u0001y\u0011\u001597\u0004\"\u0001i\u0003\r\u0019X/\u001c\u000b\u0002?!)!n\u0006a\u0001?\u0005)!/\u00198hK\")An\u0006a\u0001I\u000511\u000f\\5dKNDQ\u0001K\fA\u0002%\u0002")
public class WindowedAdder {
    private final long window;
    private final int N;
    private final Function0<Object> now;
    private final LongAdder writer;
    private volatile int gen;
    private final AtomicInteger expiredGen;
    private final long[] buf;
    private volatile int i;
    private volatile long old;

    public static WindowedAdder apply(long l, int n, Function0<Object> function0) {
        return WindowedAdder$.MODULE$.apply(l, n, function0);
    }

    private void expired() {
        if (this.expiredGen.compareAndSet(this.gen, this.gen + 1)) {
            this.buf[this.i] = this.writer.sumThenReset();
            this.i = (this.i + 1) % this.N;
            int nskip = package$.MODULE$.min((int)((this.now.apply$mcJ$sp() - this.old) / this.window - 1L), this.N);
            if (nskip > 0) {
                int r = package$.MODULE$.min(nskip, this.N - this.i);
                Arrays.fill(this.buf, this.i, this.i + r, 0L);
                Arrays.fill(this.buf, 0, nskip - r, 0L);
                this.i = (this.i + nskip) % this.N;
            }
            this.old = this.now.apply$mcJ$sp();
            ++this.gen;
            return;
        }
    }

    public void reset() {
        Arrays.fill(this.buf, 0, this.N, 0L);
        this.writer.reset();
        this.old = this.now.apply$mcJ$sp();
    }

    public void incr() {
        this.add(1);
    }

    public void add(int x) {
        if (this.now.apply$mcJ$sp() - this.old >= this.window) {
            this.expired();
        }
        this.writer.add((long)x);
    }

    /*
     * WARNING - void declaration
     */
    public long sum() {
        void var2_2;
        if (this.now.apply$mcJ$sp() - this.old >= this.window) {
            this.expired();
        }
        int _ = this.gen;
        long sum2 = this.writer.sum();
        for (int i = 0; i < this.N; ++i) {
            sum2 += this.buf[i];
        }
        return (long)var2_2;
    }

    public WindowedAdder(long window, int N, Function0<Object> now) {
        this.window = window;
        this.N = N;
        this.now = now;
        this.writer = new LongAdder();
        this.gen = 0;
        this.expiredGen = new AtomicInteger(this.gen);
        this.buf = new long[N];
        this.i = 0;
        this.old = now.apply$mcJ$sp();
    }
}

