/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.stack;

import org.psjava.ds.deque.DoubleLinkedList;
import org.psjava.ds.stack.Stack;
import org.psjava.ds.stack.StackFactory;

public class StackFactoryUsingLinkedList {
    public static StackFactory getInstance() {
        return new StackFactory(){

            @Override
            public <T> Stack<T> create() {
                return new Stack<T>(){
                    DoubleLinkedList<T> linkedList = DoubleLinkedList.create();

                    @Override
                    public boolean isEmpty() {
                        return this.linkedList.isEmpty();
                    }

                    @Override
                    public T pop() {
                        return this.linkedList.removeLast();
                    }

                    @Override
                    public void push(T v) {
                        this.linkedList.addToLast(v);
                    }

                    @Override
                    public T top() {
                        return this.linkedList.getLast();
                    }

                    public String toString() {
                        return this.linkedList.toString();
                    }
                };
            }
        };
    }

    private StackFactoryUsingLinkedList() {
    }
}

