/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.RequestCallback;

public class LatencySubscribers {
    private volatile Subscriber subscribers;
    private static final AtomicReferenceFieldUpdater<LatencySubscribers, Subscriber> subscribersUpdater = AtomicReferenceFieldUpdater.newUpdater(LatencySubscribers.class, Subscriber.class, "subscribers");

    private static Subscriber merge(Subscriber a, Subscriber b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return (address, latency, unit) -> {
            a.receiveTiming(address, latency, unit);
            b.receiveTiming(address, latency, unit);
        };
    }

    public void subscribe(Subscriber subscriber) {
        subscribersUpdater.accumulateAndGet(this, subscriber, LatencySubscribers::merge);
    }

    public void add(InetAddressAndPort address, long latency, TimeUnit unit) {
        Subscriber subscribers = this.subscribers;
        if (subscribers != null) {
            subscribers.receiveTiming(address, latency, unit);
        }
    }

    public void maybeAdd(RequestCallback cb, InetAddressAndPort address, long latency, TimeUnit unit) {
        if (cb.trackLatencyForSnitch()) {
            this.add(address, latency, unit);
        }
    }

    public static interface Subscriber {
        public void receiveTiming(InetAddressAndPort var1, long var2, TimeUnit var4);
    }
}

