/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.concurrent.ExecutionException;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.concurrent.AsyncFuture;

public class ValidationTask
extends AsyncFuture<TreeResponse>
implements Runnable {
    private final RepairJobDesc desc;
    private final InetAddressAndPort endpoint;
    private final int nowInSec;
    private final PreviewKind previewKind;
    private boolean active = true;

    public ValidationTask(RepairJobDesc desc, InetAddressAndPort endpoint, int nowInSec, PreviewKind previewKind) {
        this.desc = desc;
        this.endpoint = endpoint;
        this.nowInSec = nowInSec;
        this.previewKind = previewKind;
    }

    @Override
    public void run() {
        RepairMessage.sendMessageWithFailureCB(new ValidationRequest(this.desc, this.nowInSec), Verb.VALIDATION_REQ, this.endpoint, this::tryFailure);
    }

    public synchronized void treesReceived(MerkleTrees trees) {
        if (trees == null) {
            this.active = false;
            this.tryFailure(RepairException.warn(this.desc, this.previewKind, "Validation failed in " + this.endpoint));
        } else if (this.active) {
            this.trySuccess(new TreeResponse(this.endpoint, trees));
        } else {
            trees.release();
            this.trySuccess(null);
        }
    }

    public synchronized void abort() {
        if (this.active) {
            if (this.isDone()) {
                try {
                    TreeResponse response = (TreeResponse)this.get();
                    if (response.trees != null) {
                        response.trees.release();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.active = false;
        }
    }

    public synchronized boolean isActive() {
        return this.active;
    }
}

