/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="getfullquerylog", description="Print configuration of fql if enabled, otherwise the configuration reflected in cassandra.yaml")
public class GetFullQueryLog
extends NodeTool.NodeToolCmd {
    @Override
    protected void execute(NodeProbe probe) {
        TableBuilder tableBuilder = new TableBuilder();
        tableBuilder.add("enabled", Boolean.toString(probe.getStorageService().isFullQueryLogEnabled()));
        FullQueryLoggerOptions options = probe.getFullQueryLoggerOptions();
        tableBuilder.add("log_dir", options.log_dir);
        tableBuilder.add("archive_command", options.archive_command);
        tableBuilder.add("roll_cycle", options.roll_cycle);
        tableBuilder.add("block", Boolean.toString(options.block));
        tableBuilder.add("max_log_size", Long.toString(options.max_log_size));
        tableBuilder.add("max_queue_weight", Integer.toString(options.max_queue_weight));
        tableBuilder.add("max_archive_retries", Long.toString(options.max_archive_retries));
        tableBuilder.printTo(probe.output().out);
    }
}

