/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.audit.AuditLogFilter;
import org.apache.cassandra.audit.AuditLogManagerMBean;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.audit.AuditLogOptionsCompositeData;
import org.apache.cassandra.audit.BinAuditLogger;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.audit.NoOpAuditLogger;
import org.apache.cassandra.auth.AuthEvents;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.PasswordObfuscator;
import org.apache.cassandra.cql3.QueryEvents;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogManager
implements QueryEvents.Listener,
AuthEvents.Listener,
AuditLogManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogManager.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=AuditLogManager";
    public static final AuditLogManager instance = new AuditLogManager();
    private volatile IAuditLogger auditLogger;
    private volatile AuditLogFilter filter;
    private volatile AuditLogOptions auditLogOptions = DatabaseDescriptor.getAuditLoggingOptions();

    private AuditLogManager() {
        if (this.auditLogOptions.enabled) {
            logger.info("Audit logging is enabled.");
            this.auditLogger = this.getAuditLogger(this.auditLogOptions);
        } else {
            logger.debug("Audit logging is disabled.");
            this.auditLogger = new NoOpAuditLogger(Collections.emptyMap());
        }
        this.filter = AuditLogFilter.create(this.auditLogOptions);
    }

    public void initialize() {
        if (DatabaseDescriptor.getAuditLoggingOptions().enabled) {
            this.registerAsListener();
        }
        if (!MBeanWrapper.instance.isRegistered(MBEAN_NAME)) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        }
    }

    private IAuditLogger getAuditLogger(AuditLogOptions options) throws ConfigurationException {
        ParameterizedClass logger = options.logger;
        if (logger != null && logger.class_name != null) {
            return FBUtilities.newAuditLogger(logger.class_name, logger.parameters == null ? Collections.emptyMap() : logger.parameters);
        }
        return new BinAuditLogger(options);
    }

    @VisibleForTesting
    public IAuditLogger getLogger() {
        return this.auditLogger;
    }

    public boolean isEnabled() {
        return this.auditLogger.isEnabled();
    }

    public AuditLogOptions getAuditLogOptions() {
        return this.auditLogger.isEnabled() ? this.auditLogOptions : DatabaseDescriptor.getAuditLoggingOptions();
    }

    @Override
    public CompositeData getAuditLogOptionsData() {
        return AuditLogOptionsCompositeData.toCompositeData(instance.getAuditLogOptions());
    }

    private void log(AuditLogEntry logEntry) {
        if (!this.filter.isFiltered(logEntry)) {
            this.auditLogger.log(logEntry);
        }
    }

    private void log(AuditLogEntry logEntry, Exception e) {
        this.log(logEntry, e, null);
    }

    private void log(AuditLogEntry logEntry, Exception e, List<String> queries) {
        AuditLogEntry.Builder builder = new AuditLogEntry.Builder(logEntry);
        if (e instanceof UnauthorizedException) {
            builder.setType(AuditLogEntryType.UNAUTHORIZED_ATTEMPT);
        } else if (e instanceof AuthenticationException) {
            builder.setType(AuditLogEntryType.LOGIN_ERROR);
        } else {
            builder.setType(AuditLogEntryType.REQUEST_FAILURE);
        }
        builder.appendToOperation(this.obfuscatePasswordInformation(e, queries));
        this.log(builder.build());
    }

    public synchronized void disableAuditLog() {
        this.unregisterAsListener();
        IAuditLogger oldLogger = this.auditLogger;
        this.auditLogger = new NoOpAuditLogger(Collections.emptyMap());
        oldLogger.stop();
    }

    public synchronized void enable(AuditLogOptions auditLogOptions) throws ConfigurationException {
        IAuditLogger oldLogger = this.auditLogger;
        try {
            if (oldLogger.getClass().getSimpleName().equals(auditLogOptions.logger.class_name)) {
                return;
            }
            this.auditLogger = this.getAuditLogger(auditLogOptions);
            this.auditLogOptions = auditLogOptions;
        }
        finally {
            this.filter = AuditLogFilter.create(auditLogOptions);
            this.updateAuditLogOptions(this.auditLogOptions, this.filter);
        }
        this.registerAsListener();
        oldLogger.stop();
    }

    private void updateAuditLogOptions(AuditLogOptions options, AuditLogFilter filter) {
        options.included_keyspaces = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.includedKeyspaces.asList());
        options.excluded_keyspaces = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.excludedKeyspaces.asList());
        options.included_categories = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.includedCategories.asList());
        options.excluded_categories = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.excludedCategories.asList());
        options.included_users = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.includedUsers.asList());
        options.excluded_users = String.join((CharSequence)",", (Iterable<? extends CharSequence>)filter.excludedUsers.asList());
    }

    private void registerAsListener() {
        QueryEvents.instance.registerListener(this);
        AuthEvents.instance.registerListener(this);
    }

    private void unregisterAsListener() {
        QueryEvents.instance.unregisterListener(this);
        AuthEvents.instance.unregisterListener(this);
    }

    @Override
    public void querySuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setType(statement.getAuditLogContext().auditLogEntryType).setOperation(query).setTimestamp(queryTime).setScope(statement).setKeyspace(state, statement).setOptions(options).build();
        this.log(entry);
    }

    @Override
    public void queryFailure(CQLStatement stmt, String query, QueryOptions options, QueryState state, Exception cause) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(query).setOptions(options).build();
        this.log(entry, cause, (List<String>)(query == null ? null : ImmutableList.of((Object)query)));
    }

    @Override
    public void executeSuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setType(statement.getAuditLogContext().auditLogEntryType).setOperation(query).setTimestamp(queryTime).setScope(statement).setKeyspace(state, statement).setOptions(options).build();
        this.log(entry);
    }

    @Override
    public void executeFailure(CQLStatement statement, String query, QueryOptions options, QueryState state, Exception cause) {
        AuditLogEntry entry = null;
        if (cause instanceof PreparedQueryNotFoundException) {
            entry = new AuditLogEntry.Builder(state).setOperation(query == null ? "null" : query).setOptions(options).build();
        } else if (statement != null) {
            entry = new AuditLogEntry.Builder(state).setOperation(query == null ? statement.toString() : query).setType(statement.getAuditLogContext().auditLogEntryType).setScope(statement).setKeyspace(state, statement).setOptions(options).build();
        }
        if (entry != null) {
            this.log(entry, cause, (List<String>)(query == null ? null : ImmutableList.of((Object)query)));
        }
    }

    @Override
    public void batchSuccess(BatchStatement.Type batchType, List<? extends CQLStatement> statements, List<String> queries, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        List<AuditLogEntry> entries = AuditLogManager.buildEntriesForBatch(statements, queries, state, options, queryTime);
        for (AuditLogEntry auditLogEntry : entries) {
            this.log(auditLogEntry);
        }
    }

    @Override
    public void batchFailure(BatchStatement.Type batchType, List<? extends CQLStatement> statements, List<String> queries, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, Exception cause) {
        String auditMessage = String.format("BATCH of %d statements at consistency %s", new Object[]{statements.size(), options.getConsistency()});
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(auditMessage).setOptions(options).setType(AuditLogEntryType.BATCH).build();
        this.log(entry, cause, queries);
    }

    private static List<AuditLogEntry> buildEntriesForBatch(List<? extends CQLStatement> statements, List<String> queries, QueryState state, QueryOptions options, long queryStartTimeMillis) {
        ArrayList<AuditLogEntry> auditLogEntries = new ArrayList<AuditLogEntry>(statements.size() + 1);
        UUID batchId = UUID.randomUUID();
        String queryString = String.format("BatchId:[%s] - BATCH of [%d] statements", batchId, statements.size());
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(queryString).setOptions(options).setTimestamp(queryStartTimeMillis).setBatch(batchId).setType(AuditLogEntryType.BATCH).build();
        auditLogEntries.add(entry);
        for (int i = 0; i < statements.size(); ++i) {
            CQLStatement statement = statements.get(i);
            entry = new AuditLogEntry.Builder(state).setType(statement.getAuditLogContext().auditLogEntryType).setOperation(queries.get(i)).setTimestamp(queryStartTimeMillis).setScope(statement).setKeyspace(state, statement).setOptions(options).setBatch(batchId).build();
            auditLogEntries.add(entry);
        }
        return auditLogEntries;
    }

    @Override
    public void prepareSuccess(CQLStatement statement, String query, QueryState state, long queryTime, ResultMessage.Prepared response) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(query).setType(AuditLogEntryType.PREPARE_STATEMENT).setScope(statement).setKeyspace(statement).build();
        this.log(entry);
    }

    @Override
    public void prepareFailure(@Nullable CQLStatement stmt, @Nullable String query, QueryState state, Exception cause) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(query).setType(AuditLogEntryType.PREPARE_STATEMENT).build();
        this.log(entry, cause);
    }

    @Override
    public void authSuccess(QueryState state) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation("LOGIN SUCCESSFUL").setType(AuditLogEntryType.LOGIN_SUCCESS).build();
        this.log(entry);
    }

    @Override
    public void authFailure(QueryState state, Exception cause) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation("LOGIN FAILURE").setType(AuditLogEntryType.LOGIN_ERROR).build();
        this.log(entry, cause);
    }

    private String obfuscatePasswordInformation(Exception e, List<String> queries) {
        if (e instanceof SyntaxException && queries != null && !queries.isEmpty()) {
            for (String query : queries) {
                if (!query.toLowerCase().contains(PasswordObfuscator.PASSWORD_TOKEN)) continue;
                return "Syntax Exception. Obscured for security reasons.";
            }
        }
        return PasswordObfuscator.obfuscate(e.getMessage());
    }
}

