/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.ConfigurationException;

public class InheritingClass
extends ParameterizedClass {
    public String inherits = null;

    public InheritingClass() {
    }

    public InheritingClass(String inherits, String class_name, Map<String, String> parameters) {
        super(class_name, parameters);
        this.inherits = inherits;
    }

    public InheritingClass(Map<String, ?> p) {
        super(p);
        this.inherits = p.get("inherits").toString();
    }

    public ParameterizedClass resolve(Map<String, ParameterizedClass> map) {
        LinkedHashMap<String, String> resolvedParameters;
        if (this.inherits == null) {
            return this;
        }
        ParameterizedClass parent = map.get(this.inherits);
        if (parent == null) {
            throw new ConfigurationException("Configuration definition inherits unknown " + this.inherits + ". A configuration can only extend one defined earlier or \"default\".");
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            resolvedParameters = parent.parameters;
        } else if (parent.parameters == null || parent.parameters.isEmpty()) {
            resolvedParameters = this.parameters;
        } else {
            resolvedParameters = new LinkedHashMap<String, String>(parent.parameters);
            resolvedParameters.putAll(this.parameters);
        }
        String resolvedClass = this.class_name == null ? parent.class_name : this.class_name;
        return new ParameterizedClass(resolvedClass, (Map<String, String>)resolvedParameters);
    }

    @Override
    public String toString() {
        return (String)(this.inherits != null ? this.inherits + "+" : "") + (this.class_name != null ? this.class_name : "") + (this.parameters != null ? this.parameters.toString() : "");
    }
}

