/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DurationSpec;

public class RetrySpec {
    public static final MaxAttempt DEFAULT_MAX_ATTEMPTS = MaxAttempt.DISABLED;
    public static final DurationSpec.LongMillisecondsBound DEFAULT_BASE_SLEEP = new DurationSpec.LongMillisecondsBound("200ms");
    public static final DurationSpec.LongMillisecondsBound DEFAULT_MAX_SLEEP = new DurationSpec.LongMillisecondsBound("1s");
    public MaxAttempt maxAttempts = DEFAULT_MAX_ATTEMPTS;
    public DurationSpec.LongMillisecondsBound baseSleepTime = DEFAULT_BASE_SLEEP;
    public DurationSpec.LongMillisecondsBound maxSleepTime = DEFAULT_MAX_SLEEP;

    public RetrySpec() {
    }

    public RetrySpec(MaxAttempt maxAttempts, DurationSpec.LongMillisecondsBound baseSleepTime, DurationSpec.LongMillisecondsBound maxSleepTime) {
        this.maxAttempts = maxAttempts;
        this.baseSleepTime = baseSleepTime;
        this.maxSleepTime = maxSleepTime;
    }

    public boolean isEnabled() {
        return this.maxAttempts != MaxAttempt.DISABLED;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.maxAttempts = MaxAttempt.DISABLED;
        } else if (this.maxAttempts == MaxAttempt.DISABLED) {
            this.maxAttempts = new MaxAttempt(2);
        }
    }

    @Nullable
    public MaxAttempt getMaxAttempts() {
        return !this.isEnabled() ? null : this.maxAttempts;
    }

    @Nullable
    public DurationSpec.LongMillisecondsBound getBaseSleepTime() {
        return !this.isEnabled() ? null : this.baseSleepTime;
    }

    public DurationSpec.LongMillisecondsBound getMaxSleepTime() {
        return !this.isEnabled() ? null : this.maxSleepTime;
    }

    public String toString() {
        return "RetrySpec{maxAttempts=" + this.maxAttempts + ", baseSleepTime=" + this.baseSleepTime + ", maxSleepTime=" + this.maxSleepTime + "}";
    }

    public static class Partial
    extends RetrySpec {
        public Partial() {
            this.maxAttempts = null;
            this.baseSleepTime = null;
            this.maxSleepTime = null;
        }

        public RetrySpec withDefaults(RetrySpec defaultValues) {
            MaxAttempt maxAttempts = Partial.nonNull(this.maxAttempts, defaultValues.getMaxAttempts(), DEFAULT_MAX_ATTEMPTS);
            DurationSpec.LongMillisecondsBound baseSleepTime = Partial.nonNull(this.baseSleepTime, defaultValues.getBaseSleepTime(), DEFAULT_BASE_SLEEP);
            DurationSpec.LongMillisecondsBound maxSleepTime = Partial.nonNull(this.maxSleepTime, defaultValues.getMaxSleepTime(), DEFAULT_MAX_SLEEP);
            return new RetrySpec(maxAttempts, baseSleepTime, maxSleepTime);
        }

        private static <T> T nonNull(@Nullable T left, @Nullable T right, T defaultValue) {
            if (left != null) {
                return left;
            }
            if (right != null) {
                return right;
            }
            return defaultValue;
        }
    }

    public static class MaxAttempt {
        public static final MaxAttempt DISABLED = new MaxAttempt();
        public final int value;

        public MaxAttempt(int value) {
            if (value < 1) {
                throw new IllegalArgumentException("max attempt must be positive; but given " + value);
            }
            this.value = value;
        }

        private MaxAttempt() {
            this.value = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof Integer) {
                return this.value == (Integer)o;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            MaxAttempt that = (MaxAttempt)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

