/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.functions.types.CodecRegistry;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.ParseUtils;
import org.apache.cassandra.cql3.functions.types.TupleType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.UserType;
import org.apache.cassandra.cql3.functions.types.exceptions.DriverInternalError;
import org.apache.cassandra.cql3.functions.types.utils.Bytes;
import org.apache.cassandra.transport.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeClassNameParser {
    private static final Logger logger = LoggerFactory.getLogger(DataTypeClassNameParser.class);
    private static final String REVERSED_TYPE = "org.apache.cassandra.db.marshal.ReversedType";
    private static final String FROZEN_TYPE = "org.apache.cassandra.db.marshal.FrozenType";
    private static final String LIST_TYPE = "org.apache.cassandra.db.marshal.ListType";
    private static final String SET_TYPE = "org.apache.cassandra.db.marshal.SetType";
    private static final String MAP_TYPE = "org.apache.cassandra.db.marshal.MapType";
    private static final String UDT_TYPE = "org.apache.cassandra.db.marshal.UserType";
    private static final String TUPLE_TYPE = "org.apache.cassandra.db.marshal.TupleType";
    private static final String DURATION_TYPE = "org.apache.cassandra.db.marshal.DurationType";
    private static final String VECTOR_TYPE = "org.apache.cassandra.db.marshal.VectorType";
    private static final ImmutableMap<String, DataType> cassTypeToDataType = new ImmutableMap.Builder().put((Object)"org.apache.cassandra.db.marshal.AsciiType", (Object)DataType.ascii()).put((Object)"org.apache.cassandra.db.marshal.LongType", (Object)DataType.bigint()).put((Object)"org.apache.cassandra.db.marshal.BytesType", (Object)DataType.blob()).put((Object)"org.apache.cassandra.db.marshal.BooleanType", (Object)DataType.cboolean()).put((Object)"org.apache.cassandra.db.marshal.CounterColumnType", (Object)DataType.counter()).put((Object)"org.apache.cassandra.db.marshal.DecimalType", (Object)DataType.decimal()).put((Object)"org.apache.cassandra.db.marshal.DoubleType", (Object)DataType.cdouble()).put((Object)"org.apache.cassandra.db.marshal.FloatType", (Object)DataType.cfloat()).put((Object)"org.apache.cassandra.db.marshal.InetAddressType", (Object)DataType.inet()).put((Object)"org.apache.cassandra.db.marshal.Int32Type", (Object)DataType.cint()).put((Object)"org.apache.cassandra.db.marshal.UTF8Type", (Object)DataType.text()).put((Object)"org.apache.cassandra.db.marshal.TimestampType", (Object)DataType.timestamp()).put((Object)"org.apache.cassandra.db.marshal.SimpleDateType", (Object)DataType.date()).put((Object)"org.apache.cassandra.db.marshal.TimeType", (Object)DataType.time()).put((Object)"org.apache.cassandra.db.marshal.UUIDType", (Object)DataType.uuid()).put((Object)"org.apache.cassandra.db.marshal.IntegerType", (Object)DataType.varint()).put((Object)"org.apache.cassandra.db.marshal.TimeUUIDType", (Object)DataType.timeuuid()).put((Object)"org.apache.cassandra.db.marshal.ByteType", (Object)DataType.tinyint()).put((Object)"org.apache.cassandra.db.marshal.ShortType", (Object)DataType.smallint()).put((Object)"org.apache.cassandra.db.marshal.DurationType", (Object)DataType.duration()).build();

    public static DataType parseOne(String className, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        boolean frozen = false;
        if (DataTypeClassNameParser.isReversed(className)) {
            className = DataTypeClassNameParser.getNestedClassName(className);
        } else if (DataTypeClassNameParser.isFrozen(className)) {
            frozen = true;
            className = DataTypeClassNameParser.getNestedClassName(className);
        }
        Parser parser = new Parser(className, 0);
        String next = parser.parseNextName();
        if (next.startsWith(LIST_TYPE)) {
            return DataType.list(DataTypeClassNameParser.parseOne(parser.getTypeParameters().get(0), protocolVersion, codecRegistry), frozen);
        }
        if (next.startsWith(SET_TYPE)) {
            return DataType.set(DataTypeClassNameParser.parseOne(parser.getTypeParameters().get(0), protocolVersion, codecRegistry), frozen);
        }
        if (next.startsWith(MAP_TYPE)) {
            List<String> params = parser.getTypeParameters();
            return DataType.map(DataTypeClassNameParser.parseOne(params.get(0), protocolVersion, codecRegistry), DataTypeClassNameParser.parseOne(params.get(1), protocolVersion, codecRegistry), frozen);
        }
        if (frozen) {
            logger.warn("Got o.a.c.db.marshal.FrozenType for something else than a collection, this driver version might be too old for your version of Cassandra");
        }
        if (DataTypeClassNameParser.isVectorType(next)) {
            List<String> parameters = parser.getTypeParameters();
            DataType subtype = DataTypeClassNameParser.parseOne(parameters.get(0), protocolVersion, codecRegistry);
            int dimensions = Integer.parseInt(parameters.get(1));
            return DataType.vector(subtype, dimensions);
        }
        if (DataTypeClassNameParser.isUserType(next)) {
            ++parser.idx;
            String keyspace = parser.readOne();
            parser.skipBlankAndComma();
            String typeName = TypeCodec.varchar().deserialize(Bytes.fromHexString("0x" + parser.readOne()), protocolVersion);
            parser.skipBlankAndComma();
            Map<String, String> rawFields = parser.getNameAndTypeParameters();
            ArrayList<UserType.Field> fields = new ArrayList<UserType.Field>(rawFields.size());
            for (Map.Entry<String, String> entry : rawFields.entrySet()) {
                fields.add(new UserType.Field(entry.getKey(), DataTypeClassNameParser.parseOne(entry.getValue(), protocolVersion, codecRegistry)));
            }
            return new UserType(keyspace, typeName, true, fields, protocolVersion, codecRegistry);
        }
        if (DataTypeClassNameParser.isTupleType(next)) {
            List<String> rawTypes = parser.getTypeParameters();
            ArrayList<DataType> types = new ArrayList<DataType>(rawTypes.size());
            for (String rawType : rawTypes) {
                types.add(DataTypeClassNameParser.parseOne(rawType, protocolVersion, codecRegistry));
            }
            return new TupleType(types, protocolVersion, codecRegistry);
        }
        DataType type = (DataType)cassTypeToDataType.get((Object)next);
        return type == null ? DataType.custom(className) : type;
    }

    public static boolean isReversed(String className) {
        return className.startsWith(REVERSED_TYPE);
    }

    public static boolean isFrozen(String className) {
        return className.startsWith(FROZEN_TYPE);
    }

    private static String getNestedClassName(String className) {
        Parser p = new Parser(className, 0);
        p.parseNextName();
        List<String> l = p.getTypeParameters();
        if (l.size() != 1) {
            throw new IllegalStateException();
        }
        className = l.get(0);
        return className;
    }

    private static boolean isVectorType(String className) {
        return className.startsWith(VECTOR_TYPE);
    }

    private static boolean isUserType(String className) {
        return className.startsWith(UDT_TYPE);
    }

    private static boolean isTupleType(String className) {
        return className.startsWith(TUPLE_TYPE);
    }

    private static class Parser {
        private final String str;
        private int idx;

        private Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseNextName() {
            this.skipBlank();
            return this.readNextIdentifier();
        }

        String readOne() {
            String name = this.parseNextName();
            String args = this.readRawArguments();
            return name + args;
        }

        private String readRawArguments() {
            this.skipBlank();
            if (this.isEOS() || this.str.charAt(this.idx) == ')' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '(' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed parenthesis");
                }
                if (this.str.charAt(this.idx) == '(') {
                    ++open;
                    continue;
                }
                if (this.str.charAt(this.idx) != ')') continue;
                --open;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        List<String> getTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return list;
                }
                try {
                    list.add(this.readOne());
                }
                catch (DriverInternalError e) {
                    throw new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx), e);
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        Map<String, String> getNameAndTypeParameters() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return map;
                }
                String bbHex = this.readNextIdentifier();
                String name = null;
                try {
                    name = TypeCodec.varchar().deserialize(Bytes.fromHexString("0x" + bbHex), ProtocolVersion.CURRENT);
                }
                catch (NumberFormatException e) {
                    this.throwSyntaxError(e.getMessage());
                }
                this.skipBlank();
                if (this.str.charAt(this.idx) != ':') {
                    this.throwSyntaxError("expecting ':' token");
                }
                ++this.idx;
                this.skipBlank();
                try {
                    map.put(name, this.readOne());
                }
                catch (DriverInternalError e) {
                    throw new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx), e);
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private void throwSyntaxError(String msg) {
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
        }

        private boolean isEOS() {
            return Parser.isEOS(this.str, this.idx);
        }

        private static boolean isEOS(String str, int i) {
            return i >= str.length();
        }

        private void skipBlank() {
            this.idx = Parser.skipBlank(this.str, this.idx);
        }

        private static int skipBlank(String str, int i) {
            while (!Parser.isEOS(str, i) && ParseUtils.isBlank(str.charAt(i))) {
                ++i;
            }
            return i;
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        String readNextIdentifier() {
            int i = this.idx;
            while (!this.isEOS() && ParseUtils.isIdentifierChar(this.str.charAt(this.idx))) {
                ++this.idx;
            }
            return this.str.substring(i, this.idx);
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (Serializable)(this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

