/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.aggregation.GroupingState;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class GroupMaker {
    public static final GroupMaker GROUP_EVERYTHING = new GroupMaker(){

        @Override
        public boolean isNewGroup(DecoratedKey partitionKey, Clustering<?> clustering) {
            return false;
        }

        @Override
        public boolean returnAtLeastOneRow() {
            return true;
        }
    };

    public static GroupMaker newPkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, GroupingState state) {
        return new PkPrefixGroupMaker(comparator, clusteringPrefixSize, state);
    }

    public static GroupMaker newPkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize) {
        return new PkPrefixGroupMaker(comparator, clusteringPrefixSize);
    }

    public static GroupMaker newSelectorGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, Selector selector, List<ColumnMetadata> columns, GroupingState state) {
        return new SelectorGroupMaker(comparator, clusteringPrefixSize, selector, columns, state);
    }

    public static GroupMaker newSelectorGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, Selector selector, List<ColumnMetadata> columns) {
        return new SelectorGroupMaker(comparator, clusteringPrefixSize, selector, columns);
    }

    public abstract boolean isNewGroup(DecoratedKey var1, Clustering<?> var2);

    public boolean returnAtLeastOneRow() {
        return false;
    }

    private static class SelectorGroupMaker
    extends PkPrefixGroupMaker {
        private final Selector selector;
        private ByteBuffer lastOutput;
        private final Selector.InputRow input;

        public SelectorGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, Selector selector, List<ColumnMetadata> columns, GroupingState state) {
            super(comparator, clusteringPrefixSize, state);
            this.selector = selector;
            this.input = new Selector.InputRow(ProtocolVersion.CURRENT, columns, false);
            this.lastOutput = this.lastClustering == null ? null : this.executeSelector(this.lastClustering.bufferAt(clusteringPrefixSize - 1));
        }

        public SelectorGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, Selector selector, List<ColumnMetadata> columns) {
            super(comparator, clusteringPrefixSize);
            this.selector = selector;
            this.input = new Selector.InputRow(ProtocolVersion.CURRENT, columns, false);
        }

        @Override
        public boolean isNewGroup(DecoratedKey partitionKey, Clustering<?> clustering) {
            ByteBuffer output = Clustering.STATIC_CLUSTERING == clustering ? null : this.executeSelector(clustering.bufferAt(this.clusteringPrefixSize - 1));
            ByteBuffer key = partitionKey.getKey();
            boolean isNew = !key.equals(this.lastPartitionKey) || this.lastClustering == null || this.comparator.compare(this.lastClustering, clustering, this.clusteringPrefixSize - 1) != 0 || this.compareOutput(output) != 0;
            this.lastPartitionKey = key;
            this.lastClustering = Clustering.STATIC_CLUSTERING == clustering ? null : clustering;
            this.lastOutput = output;
            return isNew;
        }

        private int compareOutput(ByteBuffer output) {
            if (output == null) {
                return this.lastOutput == null ? 0 : -1;
            }
            if (this.lastOutput == null) {
                return 1;
            }
            return this.selector.getType().compare(output, this.lastOutput);
        }

        private ByteBuffer executeSelector(ByteBuffer argument) {
            this.input.add(argument);
            this.selector.addInput(this.input);
            ByteBuffer output = this.selector.getOutput(ProtocolVersion.CURRENT);
            this.selector.reset();
            this.input.reset(false);
            return output;
        }
    }

    private static class PkPrefixGroupMaker
    extends GroupMaker {
        protected final int clusteringPrefixSize;
        protected final ClusteringComparator comparator;
        protected ByteBuffer lastPartitionKey;
        protected Clustering<?> lastClustering;

        public PkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, GroupingState state) {
            this(comparator, clusteringPrefixSize);
            this.lastPartitionKey = state.partitionKey();
            this.lastClustering = state.clustering;
        }

        public PkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize) {
            this.comparator = comparator;
            this.clusteringPrefixSize = clusteringPrefixSize;
        }

        @Override
        public boolean isNewGroup(DecoratedKey partitionKey, Clustering<?> clustering) {
            ByteBuffer key = partitionKey.getKey();
            boolean isNew = !key.equals(this.lastPartitionKey) || this.lastClustering == null || this.comparator.compare(this.lastClustering, clustering, this.clusteringPrefixSize) != 0;
            this.lastPartitionKey = key;
            this.lastClustering = Clustering.STATIC_CLUSTERING == clustering ? null : clustering;
            return isNew;
        }
    }
}

