/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.utils.SyncUtil;

public abstract class FileDirectSegment
extends CommitLogSegment {
    volatile long lastWrittenPos = 0L;

    FileDirectSegment(AbstractCommitLogSegmentManager manager, ThrowingFunction<Path, FileChannel, IOException> channelFactory) {
        super(manager, channelFactory);
    }

    @Override
    void writeLogHeader() {
        super.writeLogHeader();
        try {
            this.channel.write(this.buffer.duplicate().flip());
            this.lastWrittenPos = this.buffer.position();
            this.manager.addSize(this.lastWrittenPos);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    protected void internalClose() {
        try {
            this.manager.getBufferPool().releaseBuffer(this.buffer);
            super.internalClose();
        }
        finally {
            this.manager.notifyBufferFreed();
        }
    }

    @Override
    protected void flush(int startMarker, int nextMarker) {
        try {
            SyncUtil.force(this.channel, true);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }
}

