/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import javax.annotation.Nullable;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.ShardManager;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;

public class ShardManagerNoDisks
implements ShardManager {
    final ColumnFamilyStore.VersionedLocalRanges localRanges;
    final double[] localRangePositions;

    public ShardManagerNoDisks(ColumnFamilyStore.VersionedLocalRanges localRanges) {
        this.localRanges = localRanges;
        double position = 0.0;
        ColumnFamilyStore.VersionedLocalRanges ranges = localRanges;
        this.localRangePositions = new double[ranges.size()];
        for (int i = 0; i < this.localRangePositions.length; ++i) {
            double span = ((Splitter.WeightedRange)ranges.get(i)).size();
            this.localRangePositions[i] = position += span;
        }
    }

    @Override
    public boolean isOutOfDate(long ringVersion) {
        return ringVersion != this.localRanges.ringVersion && this.localRanges.ringVersion != -1L;
    }

    @Override
    public double rangeSpanned(Range<Token> tableRange) {
        assert (!tableRange.isTrulyWrapAround());
        return this.rangeSizeNonWrapping(tableRange);
    }

    private double rangeSizeNonWrapping(Range<Token> tableRange) {
        double size = 0.0;
        for (Splitter.WeightedRange range : this.localRanges) {
            Range<Token> ix = range.range().intersectionNonWrapping(tableRange);
            if (ix == null) continue;
            size += ((Token)ix.left).size((Token)ix.right) * range.weight();
        }
        return size;
    }

    @Override
    public double localSpaceCoverage() {
        return this.localRangePositions[this.localRangePositions.length - 1];
    }

    @Override
    public double shardSetCoverage() {
        return this.localSpaceCoverage();
    }

    @Override
    public ShardTracker boundaries(int shardCount) {
        return new BoundaryTracker(shardCount);
    }

    public class BoundaryTracker
    implements ShardTracker {
        private final double rangeStep;
        private final int count;
        private int nextShardIndex;
        private int currentRange;
        private Token currentStart;
        @Nullable
        private Token currentEnd;

        public BoundaryTracker(int count) {
            this.count = count;
            this.rangeStep = ShardManagerNoDisks.this.localSpaceCoverage() / (double)count;
            this.currentStart = ((Splitter.WeightedRange)ShardManagerNoDisks.this.localRanges.get(0)).left();
            this.currentRange = 0;
            this.nextShardIndex = 1;
            this.currentEnd = this.nextShardIndex == count ? null : this.getEndToken(this.rangeStep * (double)this.nextShardIndex);
        }

        private Token getEndToken(double toPos) {
            double left = this.currentRange > 0 ? ShardManagerNoDisks.this.localRangePositions[this.currentRange - 1] : 0.0;
            double right = ShardManagerNoDisks.this.localRangePositions[this.currentRange];
            while (toPos > right) {
                left = right;
                right = ShardManagerNoDisks.this.localRangePositions[++this.currentRange];
            }
            Range<Token> range = ((Splitter.WeightedRange)ShardManagerNoDisks.this.localRanges.get(this.currentRange)).range();
            return this.currentStart.getPartitioner().split((Token)range.left, (Token)range.right, (toPos - left) / (right - left));
        }

        @Override
        public Token shardStart() {
            return this.currentStart;
        }

        @Override
        public Token shardEnd() {
            return this.currentEnd;
        }

        @Override
        public Range<Token> shardSpan() {
            return new Range<Token>(this.currentStart, this.currentEnd != null ? this.currentEnd : this.currentStart.getPartitioner().getMinimumToken());
        }

        @Override
        public double shardSpanSize() {
            return this.rangeStep;
        }

        @Override
        public boolean advanceTo(Token nextToken) {
            if (this.currentEnd == null || nextToken.compareTo(this.currentEnd) <= 0) {
                return false;
            }
            do {
                this.currentStart = this.currentEnd;
                this.currentEnd = ++this.nextShardIndex == this.count ? null : this.getEndToken(this.rangeStep * (double)this.nextShardIndex);
            } while (this.currentEnd != null && nextToken.compareTo(this.currentEnd) > 0);
            return true;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public double fractionInShard(Range<Token> targetSpan) {
            Range<Token> shardSpan = this.shardSpan();
            Range<Token> covered = targetSpan.intersectionNonWrapping(shardSpan);
            if (covered == null) {
                return 0.0;
            }
            if (covered == targetSpan) {
                return 1.0;
            }
            double inShardSize = covered == shardSpan ? this.shardSpanSize() : ShardManagerNoDisks.this.rangeSpanned(covered);
            double totalSize = ShardManagerNoDisks.this.rangeSpanned(targetSpan);
            return inShardSize / totalSize;
        }

        @Override
        public double rangeSpanned(PartitionPosition first, PartitionPosition last) {
            return ShardManagerNoDisks.this.rangeSpanned(first, last);
        }

        @Override
        public int shardIndex() {
            return this.nextShardIndex - 1;
        }
    }
}

