/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.cassandra.db.guardrails.Guardrail;
import org.apache.cassandra.service.ClientState;

public class Predicates<T>
extends Guardrail {
    private final Function<ClientState, Predicate<T>> warnPredicate;
    private final Function<ClientState, Predicate<T>> failurePredicate;
    private final MessageProvider<T> messageProvider;

    Predicates(String name, @Nullable String reason, Function<ClientState, Predicate<T>> warnPredicate, Function<ClientState, Predicate<T>> failurePredicate, MessageProvider<T> messageProvider) {
        super(name, reason);
        this.warnPredicate = warnPredicate;
        this.failurePredicate = failurePredicate;
        this.messageProvider = messageProvider;
    }

    public void guard(T value, @Nullable ClientState state) {
        if (!this.enabled(state)) {
            return;
        }
        if (this.failurePredicate.apply(state).test(value)) {
            this.fail(this.messageProvider.createMessage(false, value), state);
        } else if (this.warnPredicate.apply(state).test(value)) {
            this.warn(this.messageProvider.createMessage(true, value));
        }
    }

    public static interface MessageProvider<T> {
        public String createMessage(boolean var1, T var2);
    }
}

