/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractBufferClusteringPrefix;
import org.apache.cassandra.db.BufferClustering;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.BufferClusteringBoundary;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;

class ByteBufferObjectFactory
implements ValueAccessor.ObjectFactory<ByteBuffer> {
    private static final BufferClusteringBound BOTTOM_BOUND = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final BufferClusteringBound TOP_BOUND = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final BufferClusteringBound MAX_START_BOUND = new BufferClusteringBound(ClusteringPrefix.Kind.EXCL_START_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final BufferClusteringBound MIN_END_BOUND = new BufferClusteringBound(ClusteringPrefix.Kind.EXCL_END_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
    static final ValueAccessor.ObjectFactory<ByteBuffer> instance = new ByteBufferObjectFactory();

    private ByteBufferObjectFactory() {
    }

    @Override
    public Cell<ByteBuffer> cell(ColumnMetadata column, long timestamp, int ttl, long localDeletionTime, ByteBuffer value, CellPath path) {
        return new BufferCell(column, timestamp, ttl, localDeletionTime, value, path);
    }

    public Clustering<ByteBuffer> clustering(ByteBuffer ... values) {
        return new BufferClustering(values);
    }

    @Override
    public Clustering<ByteBuffer> clustering() {
        return Clustering.EMPTY;
    }

    @Override
    public Clustering<ByteBuffer> staticClustering() {
        return Clustering.STATIC_CLUSTERING;
    }

    public ClusteringBound<ByteBuffer> bound(ClusteringPrefix.Kind kind, ByteBuffer ... values) {
        return new BufferClusteringBound(kind, values);
    }

    @Override
    public ClusteringBound<ByteBuffer> bound(ClusteringPrefix.Kind kind) {
        switch (kind) {
            case EXCL_END_BOUND: {
                return MIN_END_BOUND;
            }
            case INCL_START_BOUND: {
                return BOTTOM_BOUND;
            }
            case INCL_END_BOUND: {
                return TOP_BOUND;
            }
            case EXCL_START_BOUND: {
                return MAX_START_BOUND;
            }
        }
        throw new AssertionError((Object)String.format("Unexpected kind %s for empty bound or boundary", new Object[]{kind}));
    }

    public ClusteringBoundary<ByteBuffer> boundary(ClusteringPrefix.Kind kind, ByteBuffer ... values) {
        return new BufferClusteringBoundary(kind, values);
    }
}

